/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.predicate.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.api.v0.predicate.Registries;
import com.sigmundgranaas.forgero.minecraft.common.match.MinecraftContextKeys;
import com.sigmundgranaas.forgero.minecraft.common.predicate.GroupEntry;
import com.sigmundgranaas.forgero.minecraft.common.predicate.KeyPair;
import com.sigmundgranaas.forgero.minecraft.common.predicate.SpecificationBackedPredicateCodec;
import java.util.function.Predicate;
import net.minecraft.class_1297;

public class EntityPredicate
implements Predicate<class_1297>,
Matchable {
    private final GroupEntry<KeyPair<Predicate<class_1297>>> entry;
    private static final String type = "minecraft:entity";
    public static final MapCodec<GroupEntry<KeyPair<Predicate<class_1297>>>> ENTITY_CODEC = new SpecificationBackedPredicateCodec<class_1297>("minecraft:entity", Registries.ENTITY_CODEC_REGISTRY);
    public static final Codec<EntityPredicate> CODEC = new MapCodec.MapCodecCodec(ENTITY_CODEC.xmap(EntityPredicate::new, entityPredicate -> entityPredicate.entry));

    public EntityPredicate(GroupEntry<KeyPair<Predicate<class_1297>>> entry) {
        this.entry = entry;
    }

    @Override
    public boolean test(class_1297 entity) {
        return this.entry.entries().stream().map(KeyPair::value).allMatch(specification -> specification.test(entity));
    }

    public boolean test(Matchable match, MatchContext context) {
        Boolean entity = context.get(MinecraftContextKeys.ENTITY).map(this::test).orElse(false);
        if (entity.booleanValue()) {
            return true;
        }
        return context.get(MinecraftContextKeys.ENTITY_TARGET).map(this::test).orElse(false);
    }
}

