/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.predicate.flag;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.sigmundgranaas.forgero.minecraft.common.predicate.KeyPair;
import com.sigmundgranaas.forgero.minecraft.common.predicate.KeyProvider;
import com.sigmundgranaas.forgero.minecraft.common.predicate.SpecificationRegistry;
import com.sigmundgranaas.forgero.minecraft.common.predicate.flag.FlagGroupPredicate;
import com.sigmundgranaas.forgero.minecraft.common.predicate.flag.FlagPredicateInstance;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FlagGroupCodec<R>
implements Codec<KeyPair<FlagGroupPredicate<R>>> {
    private final Codec<FlagGroupPredicate<R>> codec;
    private final SpecificationRegistry<Predicate<R>> registry;
    private final String key;

    public FlagGroupCodec(SpecificationRegistry<Predicate<R>> registry, String key) {
        this.codec = this.createFlagPredicateCodec(registry, key);
        this.registry = registry;
        this.key = key;
    }

    public Codec<KeyPair<Predicate<R>>> asPredicateCodec() {
        return this;
    }

    private static <R> List<FlagPredicateInstance<R>> mapToFlags(Map<String, Boolean> map, KeyProvider<KeyPair<Predicate<R>>> predicateProvider) {
        return map.entrySet().stream().map(entry -> FlagGroupCodec.createFlag((String)entry.getKey(), (Boolean)entry.getValue(), predicateProvider)).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private static <R> Optional<FlagPredicateInstance<R>> createFlag(String key, boolean flag, KeyProvider<KeyPair<Predicate<R>>> predicateProvider) {
        return predicateProvider.apply(key).map(entry -> FlagPredicateInstance.of(entry, flag));
    }

    private static <R> Map<String, Boolean> flagsToMap(List<FlagPredicateInstance<R>> flags) {
        return flags.stream().collect(Collectors.toMap(FlagPredicateInstance::key, FlagPredicateInstance::flag));
    }

    public Codec<FlagGroupPredicate<R>> createFlagPredicateCodec(final KeyProvider<KeyPair<Predicate<R>>> predicateProvider, String key) {
        MapCodec localCodec = new MapCodec<FlagGroupPredicate<R>>(){

            public <T> RecordBuilder<T> encode(FlagGroupPredicate<R> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                return null;
            }

            public <T> DataResult<FlagGroupPredicate<R>> decode(DynamicOps<T> ops, MapLike<T> input) {
                List entries = input.entries().map(entry -> {
                    String key = ops.getStringValue(entry.getFirst()).result().orElse("");
                    Optional value = ops.getBooleanValue(entry.getSecond()).result();
                    return value.flatMap(flag -> FlagGroupCodec.createFlag(key, flag, predicateProvider));
                }).flatMap(Optional::stream).collect(Collectors.toList());
                return DataResult.success(new FlagGroupPredicate(entries));
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return FlagGroupCodec.this.registry.keySet().stream().map(arg_0 -> ops.createString(arg_0));
            }
        };
        return new MapCodec.MapCodecCodec(localCodec);
    }

    public <T> DataResult<T> encode(KeyPair<FlagGroupPredicate<R>> input, DynamicOps<T> ops, T prefix) {
        return this.codec.encode(input.value(), ops, prefix);
    }

    public <T> DataResult<Pair<KeyPair<FlagGroupPredicate<R>>, T>> decode(DynamicOps<T> ops, T input) {
        return this.codec.decode(ops, input).map(pair -> pair.mapFirst(res -> KeyPair.pair(this.key, res)));
    }
}

