/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe;

import com.mojang.serialization.Codec;
import com.sigmundgranaas.forgero.core.condition.Conditions;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedTool;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompositeEncoder;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.recipe.ForgeroRecipeSerializer;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.CodecUtils;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1937;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_8566;

public class RepairKitRecipe
extends class_1867 {
    private final StateService service;

    public RepairKitRecipe(class_1867 recipe, StateService service) {
        super(recipe.method_8112(), recipe.method_45441(), recipe.method_8110(null), recipe.method_8117());
        this.service = service;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_17730(class_8566 craftingInventory, class_1937 world) {
        if (!super.method_17730(craftingInventory, world)) return false;
        if (!IntStream.range(0, 8).mapToObj(arg_0 -> ((class_8566)craftingInventory).method_5438(arg_0)).filter(stack -> this.service.convert((class_1799)stack).isPresent()).anyMatch(stack -> stack.method_7919() > 0)) return false;
        return true;
    }

    public class_1799 method_17729(class_8566 craftingInventory, class_5455 registryManager) {
        Object r;
        Optional state = IntStream.range(0, 8).mapToObj(arg_0 -> ((class_8566)craftingInventory).method_5438(arg_0)).map(this.service::convert).flatMap(Optional::stream).findFirst();
        Optional<class_1799> originalStack = IntStream.range(0, 8).mapToObj(arg_0 -> ((class_8566)craftingInventory).method_5438(arg_0)).filter(stack -> this.service.convert((class_1799)stack).isPresent()).findFirst();
        if (state.isPresent() && originalStack.isPresent() && (r = state.get()) instanceof ConstructedTool) {
            ConstructedTool tool = (ConstructedTool)r;
            ConstructedTool unbrokenState = tool.removeCondition(Conditions.BROKEN.name());
            int durability = ComputedAttribute.of((PropertyContainer)unbrokenState, (String)"DURABILITY").asInt();
            class_1799 stack2 = originalStack.get();
            stack2.method_7948().method_10566(NbtConstants.FORGERO_IDENTIFIER, (class_2520)CompositeEncoder.ENCODER.encode((State)unbrokenState));
            int newDamage = stack2.method_7919() - durability / 3;
            class_1799 newStack = stack2.method_7972();
            newStack.method_7974(Math.max(newDamage, 0));
            return newStack;
        }
        return this.method_8110(registryManager).method_7972();
    }

    public class_1865<?> method_8119() {
        return RepairKitRecipeSerializer.INSTANCE;
    }

    public static class RepairKitRecipeSerializer
    implements ForgeroRecipeSerializer,
    class_1865<RepairKitRecipe> {
        private final class_1867.class_1868 rootSerializer = new class_1867.class_1868();
        public static final RepairKitRecipeSerializer INSTANCE = new RepairKitRecipeSerializer();

        public Codec<RepairKitRecipe> method_53736() {
            return CodecUtils.extendCodec(this.rootSerializer.method_53736(), recipe -> new RepairKitRecipe((class_1867)recipe, StateService.INSTANCE), recipe -> recipe);
        }

        @Override
        public class_1865<?> getSerializer() {
            return INSTANCE;
        }

        public RepairKitRecipe read(class_2540 packetByteBuf) {
            return new RepairKitRecipe(this.rootSerializer.method_8141(packetByteBuf), StateService.INSTANCE);
        }

        public void write(class_2540 buf, RepairKitRecipe recipe) {
            this.rootSerializer.method_8143(buf, (class_1867)recipe);
        }

        @Override
        public class_2960 getIdentifier() {
            return new class_2960("forgero", RecipeTypes.REPAIR_KIT_RECIPE.getName());
        }
    }
}

