/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe;

import com.mojang.serialization.Codec;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.Upgradeable;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedSchematicPart;
import com.sigmundgranaas.forgero.minecraft.common.recipe.ForgeroRecipeSerializer;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.CodecUtils;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_8566;

public class SchematicPartRecipe
extends class_1867 {
    private final StateService service;

    public SchematicPartRecipe(class_1867 recipe, StateService service) {
        super(recipe.method_8112(), recipe.method_45441(), recipe.method_8110(null), recipe.method_8117());
        this.service = service;
    }

    private List<State> partsFromCraftingInventory(class_8566 craftingInventory) {
        ArrayList<class_1799> ingredients = new ArrayList<class_1799>();
        for (int i = 0; i < craftingInventory.method_5439(); ++i) {
            class_1799 stack = craftingInventory.method_5438(i);
            if (!this.method_8117().stream().filter(ingredient -> !ingredient.method_8103()).anyMatch(ingredient -> ingredient.method_8093(stack))) continue;
            int finalI = i;
            if (!ingredients.stream().noneMatch(item -> item.method_31574(craftingInventory.method_5438(finalI).method_7909()))) continue;
            ingredients.add(craftingInventory.method_5438(i));
        }
        return ingredients.stream().map(this.service::convert).flatMap(Optional::stream).toList();
    }

    public class_1799 method_17729(class_8566 craftingInventory, class_5455 registryManager) {
        Optional<State> target = this.service.convert(this.method_8110(null));
        if (target.isPresent()) {
            State targetState = target.get();
            List<State> parts = this.partsFromCraftingInventory(craftingInventory);
            Optional part = ConstructedSchematicPart.SchematicPartBuilder.builder(parts);
            if (part.isPresent() && targetState instanceof Upgradeable) {
                Upgradeable upgradeable = (Upgradeable)targetState;
                ConstructedSchematicPart.SchematicPartBuilder builder = (ConstructedSchematicPart.SchematicPartBuilder)part.get();
                builder.id(targetState.identifier());
                builder.addUpgrades(upgradeable.slots());
                builder.type(targetState.type());
                return this.service.convert((State)builder.build()).orElse(class_1799.field_8037);
            }
        }
        return this.method_8110(registryManager).method_7972();
    }

    public class_1865<SchematicPartRecipe> method_8119() {
        return SchematicPartRecipeSerializer.INSTANCE;
    }

    public static class SchematicPartRecipeSerializer
    implements class_1865<SchematicPartRecipe>,
    ForgeroRecipeSerializer {
        public static final SchematicPartRecipeSerializer INSTANCE = new SchematicPartRecipeSerializer();
        private final class_1867.class_1868 rootSerializer = new class_1867.class_1868();

        public Codec<SchematicPartRecipe> method_53736() {
            return CodecUtils.extendCodec(this.rootSerializer.method_53736(), recipe -> new SchematicPartRecipe((class_1867)recipe, StateService.INSTANCE), recipe -> recipe);
        }

        @Override
        public class_1865<?> getSerializer() {
            return INSTANCE;
        }

        public SchematicPartRecipe read(class_2540 packetByteBuf) {
            return new SchematicPartRecipe(this.rootSerializer.method_8141(packetByteBuf), StateService.INSTANCE);
        }

        public void write(class_2540 buf, SchematicPartRecipe recipe) {
            this.rootSerializer.method_8143(buf, (class_1867)recipe);
        }

        @Override
        public class_2960 getIdentifier() {
            return new class_2960("forgero", RecipeTypes.SCHEMATIC_PART_CRAFTING.getName());
        }
    }
}

