/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe;

import com.mojang.serialization.Codec;
import com.sigmundgranaas.forgero.core.customdata.ContainerVisitor;
import com.sigmundgranaas.forgero.core.customdata.Visitor;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.BaseComposite;
import com.sigmundgranaas.forgero.core.state.composite.Construct;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedTool;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.customdata.EnchantmentVisitor;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompositeEncoder;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.recipe.ForgeroRecipeSerializer;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.CodecUtils;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_8566;
import net.minecraft.class_8957;

public class StateCraftingRecipe
extends class_1869 {
    private final StateService service;

    public StateCraftingRecipe(class_1869 recipe, StateService service) {
        super(recipe.method_8112(), recipe.method_45441(), new class_8957(recipe.method_8158(), recipe.method_8150(), recipe.method_8117(), Optional.empty()), recipe.method_8110(null));
        this.service = service;
    }

    public boolean method_17728(class_8566 craftingInventory, class_1937 world) {
        State state;
        if (super.method_17728(craftingInventory, world) && this.result().isPresent() && (state = this.result().get()) instanceof Composite) {
            Composite result = (Composite)state;
            return IntStream.range(0, craftingInventory.method_5439()).mapToObj(arg_0 -> ((class_8566)craftingInventory).method_5438(arg_0)).map(this::convertHead).flatMap(Optional::stream).map(Identifiable::identifier).map(id -> id.split(":")[1]).anyMatch(name -> name.split("-")[0].equals(result.name().split("-")[0]));
        }
        return false;
    }

    private Optional<State> convertHead(class_1799 stack) {
        Optional<State> converted = this.service.convert(stack);
        if (converted.isPresent() && (converted.get().test((Matchable)Type.SWORD_BLADE) || converted.get().test((Matchable)Type.TOOL_PART_HEAD) || converted.get().test((Matchable)Type.ARROW_HEAD) || converted.get().test((Matchable)Type.BOW_LIMB))) {
            return converted;
        }
        return Optional.empty();
    }

    private List<State> partsFromCraftingInventory(class_8566 craftingInventory) {
        ArrayList<class_1799> ingredients = new ArrayList<class_1799>();
        for (int i = 0; i < craftingInventory.method_5439(); ++i) {
            class_1799 stack = craftingInventory.method_5438(i);
            if (!this.method_8117().stream().filter(ingredient -> !ingredient.method_8103()).anyMatch(ingredient -> ingredient.method_8093(stack))) continue;
            ingredients.add(craftingInventory.method_5438(i));
        }
        return ingredients.stream().map(this.service::convert).flatMap(Optional::stream).toList();
    }

    private List<State> upgradesFromCraftingInventory(class_8566 craftingInventory, class_5455 registryManager) {
        ArrayList<State> upgrades = new ArrayList<State>();
        for (int i = 0; i < craftingInventory.method_5439(); ++i) {
            Optional<State> state;
            class_1799 stack = craftingInventory.method_5438(i);
            if (!this.method_8117().stream().filter(ingredient -> !ingredient.method_8103()).anyMatch(ingredient -> ingredient.method_8093(stack)) || !(state = this.service.convert(stack)).isPresent() || !state.get().test((Matchable)Type.BINDING) && !state.get().test((Matchable)Type.SWORD_GUARD)) continue;
            upgrades.add(state.get());
        }
        return upgrades;
    }

    public class_1799 method_17727(class_8566 craftingInventory, class_5455 registryManager) {
        Optional<State> target = this.service.convert(this.method_8110(registryManager));
        if (target.isPresent()) {
            Construct.ConstructBuilder builder;
            State targetState = target.get();
            List<State> upgrades = this.upgradesFromCraftingInventory(craftingInventory, null);
            List<State> parts = this.partsFromCraftingInventory(craftingInventory).stream().filter(state -> !upgrades.contains(state)).toList();
            Optional toolBuilderOpt = ConstructedTool.ToolBuilder.builder(parts);
            if (toolBuilderOpt.isPresent()) {
                builder = (BaseComposite.BaseCompositeBuilder)toolBuilderOpt.get();
            } else {
                builder = Construct.builder();
                parts.forEach(arg_0 -> ((BaseComposite.BaseCompositeBuilder)builder).addIngredient(arg_0));
            }
            builder.type(targetState.type()).name(targetState.name()).nameSpace(targetState.nameSpace());
            if (targetState instanceof ConstructedTool) {
                ConstructedTool constructedTool = (ConstructedTool)targetState;
                builder.addSlotContainer(constructedTool.toolBuilder().getUpgradeContainer());
            }
            for (State upgrade : upgrades) {
                builder.addUpgrade(upgrade);
            }
            State state2 = builder.build();
            class_2487 nbt = new CompositeEncoder().encode(state2);
            class_1799 output = this.method_8110(registryManager).method_7972();
            output.method_7948().method_10566(NbtConstants.FORGERO_IDENTIFIER, (class_2520)nbt);
            if (toolBuilderOpt.isPresent()) {
                state2.accept((Visitor)ContainerVisitor.VISITOR).map(EnchantmentVisitor::ofAll).orElse(Collections.emptyList()).forEach(enchantment -> enchantment.embed(output));
            }
            output.method_7939(this.method_8110(registryManager).method_7947());
            return output;
        }
        return this.method_8110(registryManager).method_7972();
    }

    private Optional<State> result() {
        return this.service.convert(this.method_8110(null));
    }

    public class_1865<?> method_8119() {
        return StateCraftingRecipeSerializer.INSTANCE;
    }

    public static class StateCraftingRecipeSerializer
    implements class_1865<StateCraftingRecipe>,
    ForgeroRecipeSerializer {
        public static final StateCraftingRecipeSerializer INSTANCE = new StateCraftingRecipeSerializer();
        private final class_1869.class_1870 rootSerializer = new class_1869.class_1870();

        public Codec<StateCraftingRecipe> method_53736() {
            return CodecUtils.extendCodec(this.rootSerializer.method_53736(), recipe -> new StateCraftingRecipe((class_1869)recipe, StateService.INSTANCE), recipe -> recipe);
        }

        public StateCraftingRecipe read(class_2540 packetByteBuf) {
            return new StateCraftingRecipe(this.rootSerializer.method_8163(packetByteBuf), StateService.INSTANCE);
        }

        public void write(class_2540 buf, StateCraftingRecipe recipe) {
            this.rootSerializer.method_8165(buf, (class_1869)recipe);
        }

        @Override
        public class_2960 getIdentifier() {
            return new class_2960("forgero", RecipeTypes.STATE_CRAFTING_RECIPE.getName());
        }

        @Override
        public class_1865<?> getSerializer() {
            return INSTANCE;
        }
    }
}

