/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompoundEncoder;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.recipe.ForgeroRecipeSerializer;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_8059;

public class StateUpgradeRecipe
implements class_8059 {
    public final class_1856 base;
    public final class_1856 addition;
    final class_1799 result;
    private final StateService service = StateService.INSTANCE;
    public static final Integer baseIndex = 1;
    public static final Integer additionIndex = 2;

    public StateUpgradeRecipe(class_1856 base, class_1856 addition, class_1799 result) {
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        if (this.base.method_8093(inventory.method_5438(baseIndex.intValue())) && this.addition.method_8093(inventory.method_5438(additionIndex.intValue()))) {
            Optional<Composite> originStateOpt = this.service.convert(inventory.method_5438(baseIndex.intValue())).filter(Composite.class::isInstance).map(Composite.class::cast);
            Optional<State> upgradeOpt = this.service.convert(inventory.method_5438(additionIndex.intValue()));
            if (originStateOpt.isPresent() && upgradeOpt.isPresent()) {
                return originStateOpt.get().canUpgrade(upgradeOpt.get());
            }
        }
        return false;
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        State state;
        Optional<State> originStateOpt = this.service.convert(inventory.method_5438(baseIndex.intValue()));
        Optional<State> upgradeOpt = this.service.convert(inventory.method_5438(additionIndex.intValue()));
        if (originStateOpt.isPresent() && upgradeOpt.isPresent() && (state = originStateOpt.get()) instanceof Composite) {
            Composite state2 = (Composite)state;
            State upgraded = state2.upgrade(upgradeOpt.get());
            class_1799 output = this.method_8110(registryManager).method_7972();
            output.method_7980(inventory.method_5438(baseIndex.intValue()).method_7948().method_10553());
            output.method_7948().method_10566(NbtConstants.FORGERO_IDENTIFIER, (class_2520)CompoundEncoder.ENCODER.encode(upgraded));
            return output;
        }
        return inventory.method_5438(baseIndex.intValue());
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return this.result;
    }

    public boolean method_48453(class_1799 stack) {
        return false;
    }

    public boolean method_48454(class_1799 stack) {
        return this.base.method_8093(stack);
    }

    public boolean method_30029(class_1799 stack) {
        return this.addition.method_8093(stack);
    }

    public class_2371<class_1856> method_8117() {
        class_2371 list = class_2371.method_10213((int)3, (Object)class_1856.field_9017);
        list.set(baseIndex.intValue(), (Object)this.base);
        list.set(additionIndex.intValue(), (Object)this.addition);
        return list;
    }

    public boolean method_31584() {
        return Stream.of(this.base, this.addition).anyMatch(ingredient -> ingredient.method_8105().length == 0);
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements class_1865<StateUpgradeRecipe>,
    ForgeroRecipeSerializer {
        public static final Serializer INSTANCE = new Serializer();
        private static final Codec<StateUpgradeRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1856.field_46095.fieldOf("base").forGetter(recipe -> recipe.base), (App)class_1856.field_46095.fieldOf("addition").forGetter(recipe -> recipe.addition), (App)class_1799.field_47309.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, StateUpgradeRecipe::new));

        public Codec<StateUpgradeRecipe> method_53736() {
            return CODEC;
        }

        public StateUpgradeRecipe read(class_2540 packetByteBuf) {
            class_1856 ingredient = class_1856.method_8086((class_2540)packetByteBuf);
            class_1856 ingredient2 = class_1856.method_8086((class_2540)packetByteBuf);
            class_1799 itemStack = packetByteBuf.method_10819();
            return new StateUpgradeRecipe(ingredient, ingredient2, itemStack);
        }

        public void write(class_2540 packetByteBuf, StateUpgradeRecipe smithingRecipe) {
            smithingRecipe.base.method_8088(packetByteBuf);
            smithingRecipe.addition.method_8088(packetByteBuf);
            packetByteBuf.method_10793(smithingRecipe.result);
        }

        @Override
        public class_2960 getIdentifier() {
            return new class_2960("forgero", RecipeTypes.STATE_UPGRADE_RECIPE.getName());
        }

        @Override
        public class_1865<?> getSerializer() {
            return INSTANCE;
        }
    }
}

