/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.implementation;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.RecipeData;
import com.sigmundgranaas.forgero.core.state.MaterialBased;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeCreator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeGenerator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeLoader;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeWrapper;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeDataHelper;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeDataMapper;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.CompositeRecipeOptimiser;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.MaterialRepairToolGenerator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.PartSmeltingRecipeGenerator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.RepairKitRecipeGenerator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.SchematicPartGenerator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.TemplateGenerator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.ToolRecipeCreator;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RecipeCreatorImpl
implements RecipeCreator {
    private static RecipeCreator INSTANCE;
    private final List<RecipeGenerator> generators;
    private final TemplateGenerator templateGenerator;
    private final RecipeDataHelper helper;
    private final RecipeDataMapper mapper;
    private final StateService service;

    public RecipeCreatorImpl(Map<RecipeTypes, JsonObject> recipeTemplates, StateService service) {
        this.templateGenerator = new TemplateGenerator(recipeTemplates);
        this.helper = new RecipeDataHelper();
        this.mapper = new RecipeDataMapper(this.helper);
        this.generators = new ArrayList<RecipeGenerator>();
        this.service = service;
    }

    public static RecipeCreator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RecipeCreatorImpl(RecipeLoader.INSTANCE.loadRecipeTemplates(), StateService.INSTANCE);
        }
        return INSTANCE;
    }

    @Override
    public List<RecipeWrapper> createRecipes() {
        this.generators.addAll(this.compositeRecipeGenerators());
        this.generators.addAll(this.repairKitToolRecipeGenerators());
        this.generators.addAll(this.smeltingMetalPartRecipeGenerators());
        this.generators.addAll(this.woodAndStoneRepairRecipeGenerator());
        return this.generators.parallelStream().filter(RecipeGenerator::isValid).map(RecipeGenerator::generate).toList();
    }

    @Override
    public void registerGenerator(List<RecipeGenerator> generators) {
        this.generators.addAll(generators);
    }

    @Override
    public TemplateGenerator templates() {
        return this.templateGenerator;
    }

    private List<RecipeGenerator> compositeRecipeGenerators() {
        CompositeRecipeOptimiser optimiser = new CompositeRecipeOptimiser();
        List<RecipeData> recipes = ForgeroStateRegistry.RECIPES.stream().map(this.mapper).collect(Collectors.toList());
        Collection<RecipeData> optimized = optimiser.process(recipes);
        return optimized.parallelStream().map(this::dataToGenerator).flatMap(Optional::stream).toList();
    }

    private List<RecipeGenerator> repairKitToolRecipeGenerators() {
        ImmutableList materials = ForgeroStateRegistry.TREE.find(Type.TOOL_MATERIAL).map(node -> node.getResources(State.class)).orElse(ImmutableList.builder().build());
        ArrayList<RecipeGenerator> recipes = new ArrayList<RecipeGenerator>();
        for (State material : materials) {
            recipes.add(new RepairKitRecipeGenerator(material, this.templateGenerator, this.service));
        }
        return recipes;
    }

    private List<RecipeGenerator> woodAndStoneRepairRecipeGenerator() {
        ImmutableList wood = ForgeroStateRegistry.TREE.find(Type.WOOD).map(node -> node.getResources(State.class)).orElse(ImmutableList.builder().build());
        ImmutableList stone = ForgeroStateRegistry.TREE.find(Type.STONE).map(node -> node.getResources(State.class)).orElse(ImmutableList.builder().build());
        ArrayList<RecipeGenerator> recipes = new ArrayList<RecipeGenerator>();
        for (State material : Stream.of(wood, stone).flatMap(Collection::stream).toList()) {
            recipes.add(new MaterialRepairToolGenerator(material, this.templateGenerator));
        }
        return recipes;
    }

    private List<RecipeGenerator> smeltingMetalPartRecipeGenerators() {
        List<State> parts = ForgeroStateRegistry.TREE.find(Type.PART).map(node -> node.getResources(State.class)).orElse(ImmutableList.builder().build()).stream().filter(state -> {
            MaterialBased based;
            return state instanceof MaterialBased && (based = (MaterialBased)state).baseMaterial().test((Matchable)Type.METAL);
        }).toList();
        ArrayList<RecipeGenerator> recipes = new ArrayList<RecipeGenerator>();
        for (State part : parts) {
            if (!(part instanceof MaterialBased)) continue;
            MaterialBased based = (MaterialBased)part;
            recipes.add(new PartSmeltingRecipeGenerator(based.baseMaterial(), part, RecipeTypes.PART_BLASTING_RECIPE, this.templateGenerator));
            recipes.add(new PartSmeltingRecipeGenerator(based.baseMaterial(), part, RecipeTypes.PART_SMELTING_RECIPE, this.templateGenerator));
        }
        return recipes;
    }

    private Optional<RecipeGenerator> dataToGenerator(RecipeData data) {
        RecipeTypes type = RecipeTypes.of(data.type());
        if (type == RecipeTypes.SCHEMATIC_PART_CRAFTING) {
            return Optional.of(new SchematicPartGenerator(this.helper, data, this.templateGenerator));
        }
        if (type == RecipeTypes.STATE_CRAFTING_RECIPE) {
            return Optional.of(new ToolRecipeCreator(data, this.helper, this.templateGenerator));
        }
        return Optional.empty();
    }
}

