/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.implementation;

import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ResourceType;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;

public class RecipeDataHelper {
    public Optional<DataResource> findDefaultedResource(String id) {
        Optional<DataResource> resource = ForgeroStateRegistry.CONSTRUCTS.stream().filter(res -> res.identifier().equals(id)).findAny();
        if (resource.isPresent() && resource.get().resourceType() != ResourceType.DEFAULT) {
            return ForgeroStateRegistry.CONSTRUCTS.stream().filter(res -> res.type().equals(((DataResource)resource.get()).type())).filter(res -> res.resourceType() == ResourceType.DEFAULT).filter(res -> this.sameMaterial((DataResource)res, (DataResource)resource.get())).findFirst();
        }
        return resource;
    }

    public boolean stateExists(String id) {
        return ForgeroStateRegistry.STATES.contains(id);
    }

    public String ingredientToDefaultedId(IngredientData data) {
        if (data.type().equals(Identifiers.EMPTY_IDENTIFIER)) {
            Optional<DataResource> resource = this.findDefaultedResource(data.id());
            if (resource.isPresent()) {
                return resource.get().identifier();
            }
            return data.id();
        }
        return ForgeroStateRegistry.CONSTRUCTS.stream().filter(res -> res.type().equals(data.type())).filter(res -> res.resourceType() == ResourceType.DEFAULT).map(Identifiable::identifier).findFirst().orElse(data.id());
    }

    private boolean sameMaterial(DataResource res, DataResource compare) {
        Optional<String> test1 = this.getMaterial(res);
        Optional<String> test2 = this.getMaterial(compare);
        return test1.isPresent() && test2.isPresent() && test2.get().equals(test1.get());
    }

    public Optional<String> getMaterial(DataResource res) {
        return Arrays.stream(res.name().split(Common.ELEMENT_SEPARATOR)).map(element -> ForgeroStateRegistry.STATES.find(Type.MATERIAL).stream().filter(state -> ((State)state.get()).name().equals(element)).findAny()).flatMap(Optional::stream).map(Supplier::get).filter(state -> state.test((Matchable)Type.MATERIAL)).findFirst().map(Identifiable::name);
    }
}

