/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.implementation;

import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.RecipeData;
import com.sigmundgranaas.forgero.core.state.NameCompositor;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeDataHelper;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class RecipeDataMapper
implements Function<RecipeData, RecipeData> {
    private final RecipeDataHelper helper;

    public RecipeDataMapper(RecipeDataHelper helper) {
        this.helper = helper;
    }

    @Override
    public RecipeData apply(RecipeData data) {
        List<IngredientData> ingredients = data.ingredients().stream().map(this::mapIngredient).toList();
        String target = this.resolveTarget(data);
        return data.toBuilder().ingredients(ingredients).count(data.count()).target(target).build();
    }

    private IngredientData mapIngredient(IngredientData data) {
        IngredientData.IngredientDataBuilder builder = data.toBuilder();
        if (data.unique() && !data.id().equals(Identifiers.EMPTY_IDENTIFIER)) {
            String id = ForgeroStateRegistry.STATE_TO_CONTAINER.containsKey(ForgeroStateRegistry.ID_MAPPER.get(data.id())) ? (String)ForgeroStateRegistry.STATE_TO_CONTAINER.get(ForgeroStateRegistry.ID_MAPPER.get(data.id())) : (ForgeroStateRegistry.STATE_TO_CONTAINER.containsValue(data.id()) ? ForgeroStateRegistry.STATE_TO_CONTAINER.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(data.id())).map(Map.Entry::getKey).findFirst().orElse(data.id()) : data.id());
            builder.id(id);
        } else if (!data.id().equals(Identifiers.EMPTY_IDENTIFIER)) {
            builder.id(((State)ForgeroStateRegistry.stateFinder().find((String)ForgeroStateRegistry.ID_MAPPER.get(data.id())).get()).type().typeName().toLowerCase(Locale.ENGLISH));
        } else {
            builder.type(data.type().toLowerCase(Locale.ENGLISH));
        }
        return builder.build();
    }

    private String resolveTarget(RecipeData data) {
        Map idMapper = ForgeroStateRegistry.ID_MAPPER;
        if (idMapper.containsKey(data.target())) {
            return (String)idMapper.get(data.target());
        }
        List<State> states = data.ingredients().stream().map(this.helper::ingredientToDefaultedId).map(id -> Optional.ofNullable((String)idMapper.get(id)).orElse((String)id)).map(id -> ForgeroStateRegistry.STATES.find(id)).flatMap(Optional::stream).map(Supplier::get).toList();
        return String.format("%s:%s", "forgero", NameCompositor.of().compositeName(states));
    }
}

