/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.implementation;

import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.util.Utils;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeLoader;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public record RecipeLoaderImpl(String recipeFolderPath) implements RecipeLoader
{
    private static RecipeLoader INSTANCE;

    public static RecipeLoader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RecipeLoaderImpl("/data/forgero/templates/recipes");
        }
        return INSTANCE;
    }

    @Override
    public Map<RecipeTypes, JsonObject> loadRecipeTemplates() {
        HashMap<RecipeTypes, JsonObject> recipes = new HashMap<RecipeTypes, JsonObject>();
        try {
            JsonObject toolPartPatternRecipe = this.getRecipeAsJson(this.recipeFolderPath + "/toolpart_schematic_recipe.json");
            JsonObject stateCraftingRecipe = this.getRecipeAsJson(this.recipeFolderPath + "/state_crafting_recipe.json");
            JsonObject stateUpgradeRecipe = this.getRecipeAsJson(this.recipeFolderPath + "/state_upgrade_recipe.json");
            JsonObject schematicPartRecipe = this.getRecipeAsJson(this.recipeFolderPath + "/schematic_part_crafting.json");
            recipes.put(RecipeTypes.TOOLPART_SCHEMATIC_RECIPE, toolPartPatternRecipe);
            recipes.put(RecipeTypes.STATE_CRAFTING_RECIPE, stateCraftingRecipe);
            recipes.put(RecipeTypes.STATE_UPGRADE_RECIPE, stateUpgradeRecipe);
            recipes.put(RecipeTypes.SCHEMATIC_PART_CRAFTING, schematicPartRecipe);
            recipes.put(RecipeTypes.PART_SMELTING_RECIPE, this.getRecipeAsJson(this.recipeFolderPath + "/part_smelting_recipe.json"));
            recipes.put(RecipeTypes.PART_BLASTING_RECIPE, this.getRecipeAsJson(this.recipeFolderPath + "/part_blasting_recipe.json"));
            recipes.put(RecipeTypes.STATE_UPGRADE_CRAFTING_TABLE_RECIPE, this.getRecipeAsJson(this.recipeFolderPath + "/state_upgrade_crafting_table_recipe.json"));
            return recipes;
        }
        catch (JsonIOException | NullPointerException e) {
            Forgero.LOGGER.error("Unable to read recipes from: {}", (Object)this.recipeFolderPath);
            Forgero.LOGGER.error((Object)e);
            return recipes;
        }
    }

    private JsonObject getRecipeAsJson(String path) {
        return (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(Objects.requireNonNull(Utils.readJsonResourceAsString((String)path))));
    }
}

