/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.implementation;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_2960;

public class RecipeUtils {
    public static JsonObject ingredientsToJsonEntry(IngredientData data) {
        JsonObject object = new JsonObject();
        if (!data.id().equals(Identifiers.EMPTY_IDENTIFIER)) {
            Optional<class_2960> tag = StateService.INSTANCE.getMapper().stateToTag(data.id());
            if (tag.isPresent()) {
                object.addProperty("tag", tag.get().toString());
            } else {
                object.addProperty("item", data.id());
            }
        } else {
            object.addProperty("tag", "forgero:" + data.type().toLowerCase(Locale.ENGLISH));
        }
        return object;
    }

    public static String ingredientToString(IngredientData data) {
        if (!data.id().equals(Identifiers.EMPTY_IDENTIFIER)) {
            return data.id();
        }
        return data.type().toLowerCase(Locale.ENGLISH);
    }

    public static String ingredientsToRecipeId(List<IngredientData> ingredients) {
        return String.join((CharSequence)Common.ELEMENT_SEPARATOR, ingredients.stream().map(RecipeUtils::ingredientToString).toList());
    }
}

