/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator;

import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.RecipeData;
import com.sigmundgranaas.forgero.core.state.Typed;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeUtils;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class CompositeRecipeOptimiser {
    private final Map<String, List<RecipeData>> targetGroups = new HashMap<String, List<RecipeData>>();
    private final Map<String, List<String>> idTagEntries = new HashMap<String, List<String>>();
    private final Map<RecipeTypes, RecipeDataConverter> recipeDataConverters = new HashMap<RecipeTypes, RecipeDataConverter>();
    private final Map<RecipeTypes, IngredientDataConverter> ingredientDataConverters = new HashMap<RecipeTypes, IngredientDataConverter>();

    public CompositeRecipeOptimiser() {
        this.recipeDataConverters.put(RecipeTypes.STATE_CRAFTING_RECIPE, new StateCraftingRecipeDataConverter());
        this.recipeDataConverters.put(RecipeTypes.TOOLPART_SCHEMATIC_RECIPE, new ToolpartSchematicRecipeDataConverter());
        this.ingredientDataConverters.put(RecipeTypes.STATE_CRAFTING_RECIPE, new CommonIngredientDataConverter());
        this.ingredientDataConverters.put(RecipeTypes.TOOLPART_SCHEMATIC_RECIPE, new MaterialSpecificIngredientDataConverter());
    }

    public Collection<RecipeData> process(Collection<RecipeData> resources) {
        resources.forEach(this::findCommonGroup);
        return this.resolveGroups();
    }

    private void findCommonGroup(RecipeData data) {
        this.targetGroups.computeIfAbsent(data.target(), k -> new ArrayList()).add(data);
    }

    private List<RecipeData> resolveGroups() {
        return this.targetGroups.values().stream().map(this::convertCommonsToTag).flatMap(Collection::stream).toList();
    }

    private Collection<RecipeData> convertCommonsToTag(List<RecipeData> entries) {
        HashMap<String, RecipeData> recipeMap = new HashMap<String, RecipeData>();
        for (RecipeData entry : entries) {
            RecipeTypes recipeType = RecipeTypes.of(entry.type());
            RecipeDataConverter recipeDataConverter = this.recipeDataConverters.get((Object)recipeType);
            IngredientDataConverter ingredientDataConverter = this.ingredientDataConverters.get((Object)recipeType);
            if (recipeDataConverter != null && ingredientDataConverter != null) {
                List<IngredientData> convertedIngredients = entry.ingredients().stream().map(ingredientDataConverter::convert).toList();
                RecipeData newRecipe = recipeDataConverter.convert(entry, convertedIngredients);
                recipeMap.put(RecipeUtils.ingredientsToRecipeId(convertedIngredients), newRecipe);
                continue;
            }
            recipeMap.put(RecipeUtils.ingredientsToRecipeId(entry.ingredients()), entry);
        }
        return recipeMap.values();
    }

    private void placeEntryIntoTagMap(String tag, String id) {
        this.idTagEntries.computeIfAbsent(tag, k -> new ArrayList()).add(id);
    }

    private IngredientData convertIngredientData(IngredientData data, Function<IngredientData, Optional<String>> converter) {
        Optional<String> converted = converter.apply(data);
        if (converted.isPresent()) {
            this.placeEntryIntoTagMap(converted.get(), data.id());
            return data.toBuilder().type(converted.get()).id(Identifiers.EMPTY_IDENTIFIER).build();
        }
        return data;
    }

    static class StateCraftingRecipeDataConverter
    implements RecipeDataConverter {
        StateCraftingRecipeDataConverter() {
        }

        @Override
        public RecipeData convert(RecipeData original, List<IngredientData> convertedIngredients) {
            return original.toBuilder().ingredients(convertedIngredients).build();
        }
    }

    static class ToolpartSchematicRecipeDataConverter
    implements RecipeDataConverter {
        ToolpartSchematicRecipeDataConverter() {
        }

        @Override
        public RecipeData convert(RecipeData original, List<IngredientData> convertedIngredients) {
            return original.toBuilder().ingredients(convertedIngredients).build();
        }
    }

    class CommonIngredientDataConverter
    implements IngredientDataConverter {
        CommonIngredientDataConverter() {
        }

        @Override
        public IngredientData convert(IngredientData original) {
            return CompositeRecipeOptimiser.this.convertIngredientData(original, this::materialTypeTag);
        }

        private Optional<String> materialTypeTag(IngredientData data) {
            if (data.id().equals(Identifiers.EMPTY_IDENTIFIER) || !data.type().equals(Identifiers.EMPTY_IDENTIFIER)) {
                return Optional.empty();
            }
            String[] elements = data.id().split(Common.ELEMENT_SEPARATOR);
            Optional<String> type = StateService.INSTANCE.find(data.id()).map(Typed::type).map(Type::typeName).map(name -> name.toLowerCase(Locale.ENGLISH));
            if (elements.length > 1 && type.isPresent()) {
                return Optional.of(String.format("%s-%s", elements[0].split(":")[1], type.get()));
            }
            return Optional.empty();
        }
    }

    class MaterialSpecificIngredientDataConverter
    implements IngredientDataConverter {
        MaterialSpecificIngredientDataConverter() {
        }

        @Override
        public IngredientData convert(IngredientData original) {
            return CompositeRecipeOptimiser.this.convertIngredientData(original, this::removeMaterialFromId);
        }

        private Optional<String> removeMaterialFromId(IngredientData data) {
            String[] elements;
            if (!data.id().equals(Identifiers.EMPTY_IDENTIFIER) && (elements = data.id().split(Common.ELEMENT_SEPARATOR)).length > 1) {
                return Optional.of(elements[1]);
            }
            return Optional.empty();
        }
    }

    static interface RecipeDataConverter {
        public RecipeData convert(RecipeData var1, List<IngredientData> var2);
    }

    static interface IngredientDataConverter {
        public IngredientData convert(IngredientData var1);
    }
}

