/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeGenerator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeWrapper;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeWrapperImpl;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.TemplateGenerator;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PartSmeltingRecipeGenerator
implements RecipeGenerator {
    private final State material;
    private final State part;
    private final RecipeTypes template;
    private final TemplateGenerator generator;

    public PartSmeltingRecipeGenerator(State material, State part, RecipeTypes template, TemplateGenerator generator) {
        this.material = material;
        this.part = part;
        this.template = template;
        this.generator = generator;
    }

    @Override
    public boolean isValid() {
        if (!class_7923.field_41178.method_10250(new class_2960(this.part.identifier()))) {
            return false;
        }
        return ForgeroStateRegistry.STATE_TO_CONTAINER.containsKey(this.material.identifier());
    }

    @Override
    public RecipeWrapper generate() {
        JsonObject template = this.generator.generate(this.template).orElse(new JsonObject());
        template.getAsJsonObject("ingredient").addProperty("item", this.part.identifier());
        String result = Optional.ofNullable((String)ForgeroStateRegistry.STATE_TO_CONTAINER.get(this.material.identifier())).orElse(this.material.identifier());
        template.addProperty("result", result);
        template.addProperty("group", this.material.name());
        class_2960 id = new class_2960(this.part.identifier() + "-" + this.template.getName());
        return new RecipeWrapperImpl(id, template);
    }
}

