/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.RecipeData;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeGenerator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeWrapper;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeDataHelper;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeUtils;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeWrapperImpl;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.TemplateGenerator;
import java.util.stream.IntStream;
import net.minecraft.class_2960;

public class SchematicPartGenerator
implements RecipeGenerator {
    private final RecipeTypes type = RecipeTypes.SCHEMATIC_PART_CRAFTING;
    private final RecipeDataHelper helper;
    private final RecipeData data;
    private final TemplateGenerator generator;

    public SchematicPartGenerator(RecipeDataHelper helper, RecipeData data, TemplateGenerator generator) {
        this.helper = helper;
        this.data = data;
        this.generator = generator;
    }

    @Override
    public RecipeWrapper generate() {
        JsonObject template = this.generator.generate(this.type).orElse(new JsonObject());
        for (IngredientData ingredient : this.data.ingredients()) {
            IntStream.range(0, ingredient.amount()).forEach(i -> template.getAsJsonArray("ingredients").add((JsonElement)RecipeUtils.ingredientsToJsonEntry(ingredient)));
        }
        template.getAsJsonObject("result").addProperty("item", this.data.target());
        return new RecipeWrapperImpl(new class_2960(this.data.target()), template);
    }

    @Override
    public boolean isValid() {
        if (this.generator.generate(this.type).isEmpty()) {
            return false;
        }
        return this.helper.stateExists(this.data.target());
    }
}

