/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.SlotData;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeGenerator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeWrapper;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeDataHelper;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.TemplateGenerator;
import java.util.Locale;
import net.minecraft.class_2960;

public class SlotUpgradeGenerator
implements RecipeGenerator {
    private final RecipeTypes type = RecipeTypes.STATE_UPGRADE_RECIPE;
    private final RecipeDataHelper helper;
    private final TemplateGenerator generator;
    private final SlotData slot;
    private final String target;

    public SlotUpgradeGenerator(RecipeDataHelper helper, TemplateGenerator generator, SlotData slot, String target) {
        this.helper = helper;
        this.generator = generator;
        this.slot = slot;
        this.target = target;
    }

    @Override
    public RecipeWrapper generate() {
        JsonObject jsonTemplate = this.generator.generate(this.type).orElse(new JsonObject());
        jsonTemplate.getAsJsonObject("base").addProperty("item", this.target);
        jsonTemplate.getAsJsonObject("addition").addProperty("tag", "forgero:" + this.slot.type().toLowerCase(Locale.ENGLISH));
        jsonTemplate.getAsJsonObject("result").addProperty("item", this.target);
        class_2960 id = new class_2960(this.target + Common.ELEMENT_SEPARATOR + this.slot.type().toLowerCase(Locale.ENGLISH));
        return RecipeWrapper.of(id, jsonTemplate);
    }

    @Override
    public boolean isValid() {
        return this.helper.stateExists(this.target);
    }
}

