/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.RecipeData;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeGenerator;
import com.sigmundgranaas.forgero.minecraft.common.recipe.RecipeWrapper;
import com.sigmundgranaas.forgero.minecraft.common.recipe.customrecipe.RecipeTypes;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeDataHelper;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeUtils;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.RecipeWrapperImpl;
import com.sigmundgranaas.forgero.minecraft.common.recipe.implementation.generator.TemplateGenerator;
import net.minecraft.class_2960;

public class ToolRecipeCreator
implements RecipeGenerator {
    private final RecipeTypes type = RecipeTypes.STATE_CRAFTING_RECIPE;
    private final RecipeDataHelper helper;
    private final RecipeData data;
    private final TemplateGenerator generator;

    public ToolRecipeCreator(RecipeData data, RecipeDataHelper helper, TemplateGenerator generator) {
        this.data = data;
        this.helper = helper;
        this.generator = generator;
    }

    @Override
    public RecipeWrapper generate() {
        JsonObject jsonTemplate = this.generator.generate(this.type).orElse(new JsonObject());
        jsonTemplate.getAsJsonObject("key").add("H", (JsonElement)RecipeUtils.ingredientsToJsonEntry((IngredientData)this.data.ingredients().get(0)));
        jsonTemplate.getAsJsonObject("key").add("I", (JsonElement)RecipeUtils.ingredientsToJsonEntry((IngredientData)this.data.ingredients().get(1)));
        if (this.data.ingredients().size() > 2) {
            jsonTemplate.getAsJsonObject("key").add("G", (JsonElement)RecipeUtils.ingredientsToJsonEntry((IngredientData)this.data.ingredients().get(2)));
            jsonTemplate.getAsJsonArray("pattern").set(0, (JsonElement)new JsonPrimitive("  H"));
            jsonTemplate.getAsJsonArray("pattern").set(1, (JsonElement)new JsonPrimitive(" I "));
            jsonTemplate.getAsJsonArray("pattern").add((JsonElement)new JsonPrimitive("G  "));
        }
        jsonTemplate.getAsJsonObject("result").addProperty("item", this.data.target());
        return new RecipeWrapperImpl(new class_2960("forgero", RecipeUtils.ingredientsToRecipeId(this.data.ingredients())), jsonTemplate);
    }

    @Override
    public boolean isValid() {
        if (this.data.ingredients().size() > 3) {
            return false;
        }
        if (!this.helper.stateExists(this.data.target())) {
            return false;
        }
        return this.generator.generate(this.type).isPresent();
    }
}

