/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.resources;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.minecraft.common.utils.RegistryUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;

public class DisassemblyRecipeLoader {
    private static ImmutableList<DisassemblyRecipe> entries = ImmutableList.builder().build();

    public static ImmutableList<DisassemblyRecipe> getEntries() {
        return entries;
    }

    public static void reload(class_3300 manager) {
        Gson gson = new Gson();
        ArrayList localEntries = new ArrayList();
        for (class_3298 res : manager.method_14488("disassembly", path -> path.method_12832().endsWith(".json")).values()) {
            try {
                InputStream stream = res.method_14482();
                try {
                    DisassemblyData data = (DisassemblyData)gson.fromJson(new JsonReader((Reader)new InputStreamReader(stream)), DisassemblyData.class);
                    DisassemblyRecipe.of(data).ifPresent(localEntries::add);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                Forgero.LOGGER.error((Object)e);
            }
        }
        entries = ImmutableList.copyOf(localEntries);
    }

    public static class DisassemblyData {
        private List<String> results;
        private String input;

        public List<String> getResults() {
            return this.results;
        }

        public String getInput() {
            return this.input;
        }

        public void setResults(List<String> results) {
            this.results = results;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DisassemblyData)) {
                return false;
            }
            DisassemblyData other = (DisassemblyData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$results = this.getResults();
            List<String> other$results = other.getResults();
            if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
                return false;
            }
            String this$input = this.getInput();
            String other$input = other.getInput();
            return !(this$input == null ? other$input != null : !this$input.equals(other$input));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DisassemblyData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $results = this.getResults();
            result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
            String $input = this.getInput();
            result = result * 59 + ($input == null ? 43 : $input.hashCode());
            return result;
        }

        public String toString() {
            return "DisassemblyRecipeLoader.DisassemblyData(results=" + this.getResults() + ", input=" + this.getInput() + ")";
        }
    }

    public static class DisassemblyRecipe {
        private final List<class_1792> results;
        private final class_1856 input;

        public static Optional<DisassemblyRecipe> of(DisassemblyData data) {
            Optional<class_1856> input = RegistryUtils.safeId(data.getInput()).flatMap(id -> RegistryUtils.safeRegistryLookup(class_7923.field_41178, id)).map(xva$0 -> class_1856.method_8091((class_1935[])new class_1935[]{xva$0}));
            List<class_1792> results = data.results.stream().map(RegistryUtils::safeId).flatMap(Optional::stream).map(id -> RegistryUtils.safeRegistryLookup(class_7923.field_41178, id)).flatMap(Optional::stream).toList();
            if (input.isPresent() && results.size() == data.results.size()) {
                return Optional.of(new DisassemblyRecipe(results, input.get()));
            }
            return Optional.empty();
        }

        public DisassemblyRecipe(List<class_1792> results, class_1856 input) {
            this.results = results;
            this.input = input;
        }

        public List<class_1792> getResults() {
            return this.results;
        }

        public class_1856 getInput() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DisassemblyRecipe)) {
                return false;
            }
            DisassemblyRecipe other = (DisassemblyRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<class_1792> this$results = this.getResults();
            List<class_1792> other$results = other.getResults();
            if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
                return false;
            }
            class_1856 this$input = this.getInput();
            class_1856 other$input = other.getInput();
            return !(this$input == null ? other$input != null : !this$input.equals(other$input));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DisassemblyRecipe;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<class_1792> $results = this.getResults();
            result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
            class_1856 $input = this.getInput();
            result = result * 59 + ($input == null ? 43 : $input.hashCode());
            return result;
        }

        public String toString() {
            return "DisassemblyRecipeLoader.DisassemblyRecipe(results=" + this.getResults() + ", input=" + this.getInput() + ")";
        }
    }
}

