/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.resources;

import com.sigmundgranaas.forgero.minecraft.common.resources.ModContainerService;
import com.sigmundgranaas.forgero.minecraft.common.resources.loader.ModContainerFileLoader;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class FabricModFileLoader {
    private final List<ModContainerFileLoader> containers = new ModContainerService().getForgeroResourceContainers();

    public boolean resourceExists(String resource) {
        return this.containers.stream().anyMatch(container -> container.containsResource(resource));
    }

    public List<Path> getResourcesFromFolder(String folder) {
        return this.containers.stream().map(container -> container.getResourcesInFolder(folder)).flatMap(Collection::stream).toList();
    }

    public Optional<InputStream> loadFileFromMods(String resource) {
        if (this.resourceExists(resource)) {
            return this.containers.stream().filter(container -> container.containsResource(resource)).map(container -> container.loadResource(resource)).flatMap(Optional::stream).findFirst();
        }
        return Optional.empty();
    }
}

