/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.resources.loader;

import com.sigmundgranaas.forgero.core.Forgero;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.loader.api.ModContainer;

public class ModContainerFileLoader {
    private final ModContainer container;

    public ModContainerFileLoader(ModContainer container) {
        this.container = container;
    }

    public List<Path> getResourcesInFolder(String resourceLocation) {
        return this.getResourcesInFolder(resourceLocation, 4);
    }

    public List<Path> getResourcesInFolder(String resourceLocation, int depth) {
        Optional optionalPath = this.container.findPath(resourceLocation);
        if (optionalPath.isPresent()) {
            List<Path> list;
            block9: {
                Stream<Path> filesStream = Files.walk((Path)optionalPath.get(), depth, new FileVisitOption[0]);
                try {
                    list = filesStream.toList();
                    if (filesStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (filesStream != null) {
                            try {
                                filesStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Forgero.LOGGER.error("Unable to list files from {}", (Object)resourceLocation);
                        Forgero.LOGGER.error((Object)e);
                    }
                }
                filesStream.close();
            }
            return list;
        }
        return Collections.emptyList();
    }

    public boolean containsResource(String resourceLocation) {
        Optional optionalPath = this.container.findPath(resourceLocation);
        return optionalPath.isPresent();
    }

    public Optional<InputStream> loadResource(String resourceLocation) {
        ClassLoader classLoader = ModContainerFileLoader.class.getClassLoader();
        Optional<Path> optionalPath = this.container.findPath(resourceLocation).map(path -> Path.of(path.toString().split("/resources/assets/").length == 1 ? path.toString().split("/resources/assets/")[0] : path.toString().split("/resources/assets/")[1], new String[0]));
        return optionalPath.map(path -> classLoader.getResourceAsStream(resourceLocation));
    }

    private List<Path> collectResourcesFromPath(Path path) {
        Optional<Path> dirPath = this.findPathFromEnv(path);
        try {
            if (dirPath.isPresent()) {
                return Files.list(path).toList();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Forgero.LOGGER.info((Object)e);
        }
        catch (NullPointerException e) {
            Forgero.LOGGER.info("Caught a nullPointer trying to read path {}", (Object)path);
        }
        return Collections.emptyList();
    }

    private Optional<Path> findPathFromEnv(Path path) {
        try {
            return Optional.of(Paths.get(path.toUri()));
        }
        catch (FileSystemNotFoundException e) {
            return this.getPathFromJar(path);
        }
    }

    private Optional<Path> getPathFromJar(Path path) {
        HashMap env = new HashMap();
        try {
            return Optional.of(FileSystems.newFileSystem(path.toUri(), env).getPath(path.toString(), new String[0]));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }
}

