/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class StateMapper {
    private final Map<String, String> containerToStateMap;
    private final Map<String, String> stateToContainerMap;
    private final Map<String, String> stateToTagMap;
    private final Map<String, String> tagToStateMap;

    public StateMapper(Map<String, String> containerToStateMap, Map<String, String> stateToContainerMap, Map<String, String> stateToTagMap, Map<String, String> tagToStateMap) {
        this.containerToStateMap = containerToStateMap;
        this.stateToContainerMap = stateToContainerMap;
        this.stateToTagMap = stateToTagMap;
        this.tagToStateMap = tagToStateMap;
    }

    public StateMapper() {
        this.containerToStateMap = new HashMap<String, String>();
        this.stateToContainerMap = new HashMap<String, String>();
        this.stateToTagMap = new HashMap<String, String>();
        this.tagToStateMap = new HashMap<String, String>();
    }

    public Optional<String> containerToState(String id) {
        Optional<String> identifier = Optional.ofNullable(this.containerToStateMap.get(id));
        return identifier.or(() -> Optional.ofNullable(this.tagToStateMap.get(this.findTagIdFromContainer(new class_2960(id)).map(class_2960::toString).orElse(""))));
    }

    public Optional<String> containerToState(class_2960 id) {
        return this.containerToState(id.toString());
    }

    public class_2960 stateToContainer(String id) {
        Optional<String> containerId = Optional.ofNullable(this.stateToContainerMap.get(id));
        if (containerId.isPresent()) {
            return new class_2960(containerId.get());
        }
        Optional<String> containerTag = Optional.ofNullable(this.stateToTagMap.get(id));
        if (containerTag.isPresent()) {
            class_2960 tagId = new class_2960(containerTag.get());
            class_6862 tag = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)tagId);
            Iterator iterator = class_7923.field_41178.method_40286(tag).iterator();
            if (iterator.hasNext()) {
                class_6880 item = (class_6880)iterator.next();
                return class_7923.field_41178.method_10221((Object)((class_1792)item.comp_349()));
            }
            return tagId;
        }
        return new class_2960(id);
    }

    public Optional<class_2960> findTagIdFromContainer(class_2960 id) {
        for (String tag : this.stateToTagMap.values()) {
            class_2960 identifier = new class_2960(tag);
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)identifier);
            for (class_6880 item : class_7923.field_41178.method_40286(tagKey)) {
                if (!class_7923.field_41178.method_10221((Object)((class_1792)item.comp_349())).equals((Object)id)) continue;
                return Optional.of(identifier);
            }
        }
        return Optional.empty();
    }

    public Optional<class_2960> stateToTag(String id) {
        return Optional.ofNullable(this.stateToTagMap.get(id)).map(class_2960::new);
    }
}

