/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.toolhandler;

import com.sigmundgranaas.forgero.core.configuration.ForgeroConfigurationLoader;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class HungerHandler {
    private final StateService service;

    public HungerHandler(StateService service) {
        this.service = service;
    }

    public class_1269 handle(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        class_1799 stack = player.method_5998(hand);
        this.handle(player, stack);
        return class_1269.field_5811;
    }

    private void handle(class_1657 player, class_1799 stack) {
        if (player instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            if (ForgeroConfigurationLoader.configuration.weightIncreasesHunger.booleanValue()) {
                this.service.convert(stack).filter(state -> state.test((Matchable)Type.TOOL) || state.test((Matchable)Type.WEAPON)).map(state -> ComputedAttribute.of((PropertyContainer)state, (String)"WEIGHT")).map(ComputedAttribute::asInt).ifPresent(weight -> this.adjustHungerBasedOnWeight(serverPlayerEntity, (int)weight));
            }
        }
    }

    public void handle(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        class_1799 stack = player.method_6047();
        this.handle(player, stack);
    }

    private void adjustHungerBasedOnWeight(class_3222 player, int weight) {
        ConfigurationValues config = this.getConfigurationValues();
        float z = this.calculateZScore(weight, config.centerPoint, config.scaler);
        double adjustedProb = this.calculateAdjustedProbability(z, config.baseChance);
        adjustedProb = this.adjustProbabilityForSaturation(adjustedProb, player.method_7344().method_7589());
        this.applyHungerReductionBasedOnProbability(player, adjustedProb);
    }

    private ConfigurationValues getConfigurationValues() {
        return new ConfigurationValues(ForgeroConfigurationLoader.configuration.weightIncreasesHungerCenterPoint.intValue(), ForgeroConfigurationLoader.configuration.weightIncreasesHungerScalar.intValue(), ForgeroConfigurationLoader.configuration.weightIncreasesHungerBaseChance.floatValue());
    }

    private float calculateZScore(int weight, float centerPoint, float scaler) {
        return ((float)weight - centerPoint) / scaler;
    }

    private double calculateAdjustedProbability(float z, float baseChance) {
        double prob = 0.5 * (1.0 + this.erf((double)z / Math.sqrt(2.0)));
        return (double)baseChance + (prob - 0.5);
    }

    private double adjustProbabilityForSaturation(double probability, float saturation) {
        double saturationAdjustment = 1.0 - Math.min((double)saturation / 20.0, 1.0);
        return probability * saturationAdjustment;
    }

    private void applyHungerReductionBasedOnProbability(class_3222 player, double probability) {
        Random random = new Random();
        if (random.nextDouble() < probability) {
            int foodLevel = player.method_7344().method_7586();
            player.method_7344().method_7580(Math.max(foodLevel - 1, 0));
        }
    }

    private double erf(double z) {
        double t = 1.0 / (1.0 + 0.47047 * Math.abs(z));
        double poly = t * (0.3480242 - 0.0958798 * t + 0.7478556 * t * t);
        return z >= 0.0 ? 1.0 - poly * Math.exp(-z * z) : poly * Math.exp(-z * z) - 1.0;
    }

    private record ConfigurationValues(float centerPoint, float scaler, float baseChance) {
    }
}

