/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.toolhandler;

import com.sigmundgranaas.forgero.core.soul.Soul;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.SoulEncoder;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.SoulParser;
import com.sigmundgranaas.forgero.minecraft.common.mixins.OreBlockXp;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.EntityStatuses;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class SoulHandler {
    private final class_1799 stack;
    private final Soul soul;

    public SoulHandler(class_1799 stack, Soul soul) {
        this.stack = stack;
        this.soul = soul;
    }

    public static Optional<SoulHandler> of(class_1799 stack) {
        return SoulParser.of(stack).map(value -> new SoulHandler(stack, (Soul)value));
    }

    public void processMobKill(class_1297 entity, class_1937 world, class_1657 player) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            Soul handledSoul = this.soul.addXp((float)(livingEntity.method_6110() * 15));
            if (handledSoul.getLevel() > this.soul.getLevel()) {
                this.handleLevelUp(handledSoul, world, player);
            }
            handledSoul.trackMob(class_7923.field_41177.method_10221((Object)entity.method_5864()).toString(), 1);
            this.stack.method_7948().method_10562(NbtConstants.FORGERO_IDENTIFIER).method_10566(NbtConstants.SOUL_IDENTIFIER, (class_2520)SoulEncoder.ENCODER.encode(handledSoul));
        }
    }

    public void processBlockBreak(class_2338 pos, class_1937 world, class_1657 player) {
        Soul handledSoul;
        class_2680 state = world.method_8320(pos);
        float xp = state.method_26214((class_1922)world, pos) * 1.0f;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof OreBlockXp) {
            OreBlockXp ore = (OreBlockXp)class_22482;
            xp = ore.getExperienceDropped().method_35008(class_5819.method_43047()) * 15;
        }
        if ((handledSoul = this.soul.addXp(xp)).getLevel() > this.soul.getLevel()) {
            this.handleLevelUp(handledSoul, world, player);
        }
        handledSoul.trackBlock(class_7923.field_41175.method_10221((Object)state.method_26204()).toString(), 1);
        this.stack.method_7948().method_10562(NbtConstants.FORGERO_IDENTIFIER).method_10566(NbtConstants.SOUL_IDENTIFIER, (class_2520)SoulEncoder.ENCODER.encode(handledSoul));
    }

    private void handleLevelUp(Soul soul, class_1937 world, class_1657 player) {
        if (!world.method_8608()) {
            player.method_43496((class_2561)class_2561.method_43470((String)String.format("%s leveled to level %s", soul.name(), soul.getLevel())));
        }
        world.method_8421((class_1297)player, EntityStatuses.ENTITY_STATUS_SOUL_LEVEL_UP);
    }
}

