/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.toolhandler;

import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.RunnableHandler;
import com.sigmundgranaas.forgero.core.property.v2.cache.ContainerTargetPair;
import com.sigmundgranaas.forgero.core.property.v2.cache.FeatureCache;
import com.sigmundgranaas.forgero.core.property.v2.cache.FeatureContainerKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.Feature;
import com.sigmundgranaas.forgero.core.registry.SoulLevelPropertyRegistry;
import com.sigmundgranaas.forgero.core.soul.Soul;
import com.sigmundgranaas.forgero.core.soul.SoulBindable;
import com.sigmundgranaas.forgero.core.soul.SoulSource;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.EntityStatuses;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SoulReapingHandler
implements RunnableHandler {
    private final class_1657 entity;
    private final class_1309 targetEntity;
    private final StateService service;

    public SoulReapingHandler(class_1657 entity, class_1309 targetEntity, StateService service) {
        this.entity = entity;
        this.targetEntity = targetEntity;
        this.service = service;
    }

    public static SoulReapingHandler of(class_1657 entity, class_1309 targetEntity) {
        return new SoulReapingHandler(entity, targetEntity, StateService.INSTANCE);
    }

    public String type() {
        return "SOUL_REAPING_HANDLER";
    }

    public void run() {
        State state;
        class_1799 stack = this.entity.method_6047();
        Optional<State> converted = this.service.convert(stack);
        if (converted.isPresent() && (state = converted.get()) instanceof Composite) {
            Composite construct = (Composite)state;
            String name = this.targetEntity.method_16914() && this.targetEntity.method_5797() != null ? this.targetEntity.method_5797().getString() : this.targetEntity.method_5477().getString();
            SoulSource soulSource = new SoulSource(class_1299.method_5890((class_1299)this.targetEntity.method_5864()).toString(), name);
            Soul soul = new Soul(soulSource, SoulLevelPropertyRegistry.handler());
            if (!FeatureCache.check((FeatureContainerKey)FeatureContainerKey.of((PropertyContainer)construct, (ClassKey)Feature.key((String)"forgero:soul_reaping")))) {
                if (FeatureCache.check((FeatureContainerKey)new FeatureContainerKey(ContainerTargetPair.of((PropertyContainer)construct), Feature.key((String)"forgero:soul_binding")))) {
                    Composite comp;
                    Composite state2 = construct;
                    if (construct instanceof SoulBindable) {
                        SoulBindable bindable = (SoulBindable)construct;
                        state2 = bindable.bind(soul);
                    }
                    if (state2 instanceof Composite && (comp = state2).has("forgero:soul-totem").isPresent()) {
                        this.entity.method_37908().method_8421((class_1297)this.entity, EntityStatuses.ENTITY_STATUS_TOTEM);
                        state2 = comp.removeUpgrade("forgero:soul-totem");
                    }
                    this.entity.method_31548().method_5447(this.entity.method_31548().field_7545, this.service.convert((State)state2).orElse(class_1799.field_8037));
                } else if (this.hasSoulTotemInHand()) {
                    this.entity.method_37908().method_8421((class_1297)this.entity, EntityStatuses.ENTITY_STATUS_TOTEM);
                    class_1799 totemSack = this.getTotemStack();
                    totemSack.method_7934(1);
                    Composite state3 = construct;
                    if (construct instanceof SoulBindable) {
                        SoulBindable bindable = (SoulBindable)construct;
                        state3 = bindable.bind(soul);
                    }
                    this.entity.method_31548().method_5447(this.entity.method_31548().field_7545, this.service.convert((State)state3).orElse(class_1799.field_8037));
                }
            }
        }
    }

    private boolean hasSoulTotemInHand() {
        for (class_1268 hand : class_1268.values()) {
            class_1799 handStack = this.entity.method_5998(hand);
            class_1792 totem = (class_1792)class_7923.field_41178.method_10223(new class_2960("forgero:soul-totem"));
            if (totem == class_1802.field_8162 || !handStack.method_31574(totem)) continue;
            return true;
        }
        return false;
    }

    private class_1799 getTotemStack() {
        for (class_1268 hand : class_1268.values()) {
            class_1799 handStack = this.entity.method_5998(hand);
            class_1792 totem = (class_1792)class_7923.field_41178.method_10223(new class_2960("forgero:soul-totem"));
            if (totem == class_1802.field_8162 || !handStack.method_31574(totem)) continue;
            return handStack;
        }
        return class_1799.field_8037;
    }
}

