/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.toolhandler.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.cache.CacheAbleKey;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.block.ToolBlockHandler;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.concurrent.Callable;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;

public class BlockHandlerCache {
    public static final LoadingCache<String, ToolBlockHandler> blockHandlerLoadingCache = CacheBuilder.newBuilder().maximumSize(600L).expireAfterAccess(Duration.of(2L, ChronoUnit.SECONDS)).build((CacheLoader)new CacheLoader<String, ToolBlockHandler>(){

        @NotNull
        public ToolBlockHandler load(@NotNull String key) {
            return ToolBlockHandler.EMPTY;
        }
    });

    public static ToolBlockHandler computeIfAbsent(CacheAbleKey key, Callable<ToolBlockHandler> compute) {
        try {
            return (ToolBlockHandler)blockHandlerLoadingCache.get((Object)key.key(), compute);
        }
        catch (Exception e) {
            return ToolBlockHandler.EMPTY;
        }
    }

    public static void remove(CacheAbleKey key) {
        blockHandlerLoadingCache.invalidateAll();
    }

    public record BlockStateCacheKey(CacheAbleKey blockState, PropertyContainer container, class_2350[] directions) implements CacheAbleKey
    {
        public String key() {
            return this.blockState.key() + this.container.hashCode() + Arrays.toString(this.directions);
        }
    }
}

