/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.toolhandler.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.cache.CacheAbleKey;
import com.sigmundgranaas.forgero.core.property.v2.cache.FeatureCache;
import com.sigmundgranaas.forgero.core.property.v2.cache.FeatureContainerKey;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.feature.BlockBreakFeature;
import com.sigmundgranaas.forgero.minecraft.common.match.MinecraftContextKeys;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.block.BlockHandlerCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class ToolBlockHandler {
    private static final Cache<CacheAbleKey, ToolBlockHandler> blockHandlerCache = CacheBuilder.newBuilder().maximumSize(10L).softValues().build();
    private static final Map<CacheAbleKey, Boolean> canMineCache = new HashMap<CacheAbleKey, Boolean>();
    public static ToolBlockHandler EMPTY = new ToolBlockHandler(new class_2338(0, 0, 0), Collections.emptySet(), 0.0f, CacheAbleKey.EMPTY);
    private final Set<class_2338> availableBlocks;
    private final class_2338 originPos;
    private final float hardness;
    private final CacheAbleKey key;

    public ToolBlockHandler(class_2338 originPos, Set<class_2338> blocks, float hardness, CacheAbleKey key) {
        this.key = key;
        this.availableBlocks = new HashSet<class_2338>(blocks);
        this.originPos = originPos;
        this.hardness = hardness;
    }

    public static Optional<ToolBlockHandler> of(PropertyContainer container, class_2338 pos, class_1657 player) {
        class_1792 item = player.method_6047().method_7909();
        if (!item.method_7846()) {
            return Optional.empty();
        }
        FeatureContainerKey featureKey = FeatureContainerKey.of((PropertyContainer)container, BlockBreakFeature.KEY);
        Key cacheKey = new Key(player.method_6047(), pos, class_2350.method_10159((class_1297)player)[0]);
        if (!FeatureCache.check((FeatureContainerKey)featureKey) || canMineCache.containsKey(cacheKey) && !canMineCache.get(cacheKey).booleanValue()) {
            return Optional.empty();
        }
        ToolBlockHandler cachedHandler = (ToolBlockHandler)blockHandlerCache.getIfPresent((Object)cacheKey);
        if (cachedHandler != null) {
            return Optional.of(cachedHandler);
        }
        MatchContext ctx = MatchContext.of().put(MinecraftContextKeys.WORLD, (Object)player.method_37908()).put(MinecraftContextKeys.ENTITY, (Object)player).put(MinecraftContextKeys.BLOCK_TARGET, (Object)pos);
        Optional<BlockBreakFeature> featureOpt = container.stream().features(BlockBreakFeature.KEY).filter(feature -> feature.test(Matchable.DEFAULT_TRUE, ctx)).findFirst();
        if (featureOpt.isPresent()) {
            ImmutableSet selected = ImmutableSet.copyOf(featureOpt.get().selectBlocks((class_1297)player, pos));
            ToolBlockHandler handler = new ToolBlockHandler(pos, (Set<class_2338>)selected, featureOpt.get().calculateBlockBreakingDelta((class_1297)player, pos, (Set<class_2338>)selected), cacheKey);
            blockHandlerCache.put((Object)cacheKey, (Object)handler);
            return Optional.of(handler);
        }
        canMineCache.put(cacheKey, false);
        return Optional.empty();
    }

    public ToolBlockHandler handle(Consumer<class_2338> consumer) {
        for (class_2338 blockPos : this.availableBlocks) {
            consumer.accept(blockPos);
        }
        return this;
    }

    public ToolBlockHandler handleExceptOrigin(Consumer<class_2338> consumer) {
        for (class_2338 blockPos : this.availableBlocks) {
            if (blockPos.equals((Object)this.originPos)) continue;
            consumer.accept(blockPos);
        }
        return this;
    }

    public void cleanUp() {
        BlockHandlerCache.remove(this.key);
        canMineCache.clear();
    }

    public Set<class_2338> availableBlocks() {
        return this.availableBlocks;
    }

    public class_2338 originPos() {
        return this.originPos;
    }

    public float hardness() {
        return this.hardness;
    }

    public CacheAbleKey key() {
        return this.key;
    }

    public record Key(class_1799 stack, class_2338 pos, class_2350 direction) implements CacheAbleKey
    {
        public String key() {
            return this.stack.hashCode() + ":" + this.pos.method_10063() + ":" + this.direction.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.key().equals(key.key());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.key());
        }
    }
}

