/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.DynamicTooltip;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.StateWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.Writer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class CachedWriteHelper
implements Writer {
    private static final LoadingCache<Key, DynamicTooltip> tooltipCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(1L)).build((CacheLoader)new CacheLoader<Key, DynamicTooltip>(){

        @NotNull
        public DynamicTooltip load(@NotNull Key key) {
            DynamicTooltip dt = new DynamicTooltip();
            CompletableFuture.runAsync(() -> {
                ArrayList<class_2561> list = new ArrayList<class_2561>();
                key.writer.write(list, key.ctx());
                dt.updateTooltip(list);
            });
            return dt;
        }
    });
    private final State state;
    private final Writer writer;

    public CachedWriteHelper(State state, Writer writer) {
        this.state = state;
        this.writer = writer;
    }

    public static CachedWriteHelper of(State state) {
        return new CachedWriteHelper(state, StateWriter.of(state));
    }

    public static CachedWriteHelper of(State state, Writer writer) {
        return new CachedWriteHelper(state, writer);
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
        Key key = new Key(this.state, class_437.method_25442(), class_437.method_25441(), context, this.writer);
        try {
            DynamicTooltip dynamicTooltip = (DynamicTooltip)tooltipCache.get((Object)key);
            if (!dynamicTooltip.getTooltip().isEmpty()) {
                tooltip.addAll(dynamicTooltip.getTooltip());
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public record Key(State state, boolean hasShift, boolean hasCtrl, class_1836 ctx, Writer writer) {
        @Override
        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.state.hashCode(), this.hasShift(), this.hasCtrl()});
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.hasShift == key.hasShift && this.hasCtrl == key.hasCtrl && Objects.equals(this.state, key.state);
        }
    }
}

