/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip;

import com.sigmundgranaas.forgero.core.property.attribute.AttributeHelper;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.Construct;
import com.sigmundgranaas.forgero.core.state.composite.Constructed;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.Writer;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class CompositeWriter
implements Writer {
    private final Composite composite;

    public CompositeWriter(Composite composite) {
        this.composite = composite;
    }

    public static class_1814 getRarityFromInt(int rarity) {
        if (rarity >= 100) {
            return class_1814.field_8904;
        }
        if (rarity >= 80) {
            return class_1814.field_8903;
        }
        if (rarity >= 30) {
            return class_1814.field_8907;
        }
        return class_1814.field_8906;
    }

    public static void write(Composite composite, List<class_2561> tooltip, class_1836 context, int indent) {
        Constructed construct;
        StringBuilder stringIndent = new StringBuilder(" ");
        stringIndent.append(" ".repeat(Math.max(0, indent)));
        if (composite.slots().size() > 0) {
            class_5250 slots = class_2561.method_43470((String)stringIndent.toString()).method_10852((class_2561)class_2561.method_43471((String)Writer.toTranslationKey("slots")).method_27692(class_124.field_1080));
            tooltip.add((class_2561)slots);
            composite.slots().forEach(slot -> {
                Object patt2051$temp;
                class_5250 mutableText = class_2561.method_43470((String)stringIndent.toString()).method_10852((class_2561)class_2561.method_43471((String)Writer.toTranslationKey(slot.identifier().toLowerCase(Locale.ENGLISH))).method_27692(class_124.field_1080));
                if (slot.filled()) {
                    class_1814 rarity = CompositeWriter.getRarityFromInt(AttributeHelper.of((State)((State)slot.get().get())).rarity());
                    mutableText.method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852(Writer.nameToTranslatableText((State)slot.get().get())).method_27692(rarity.field_8908);
                } else {
                    mutableText.method_27693(": -").method_27692(class_124.field_1080);
                }
                tooltip.add((class_2561)mutableText);
                if (context.method_8035() && slot.filled() && (patt2051$temp = slot.get().get()) instanceof Construct) {
                    Construct constructSlot = (Construct)patt2051$temp;
                    CompositeWriter.write((Composite)constructSlot, tooltip, context, indent + 2);
                }
            });
        }
        if (composite instanceof Constructed && (construct = (Constructed)composite).parts().size() > 0) {
            class_5250 ingredients = class_2561.method_43470((String)stringIndent.toString()).method_10852((class_2561)class_2561.method_43471((String)Writer.toTranslationKey("ingredients"))).method_27693(":").method_27692(class_124.field_1080);
            tooltip.add((class_2561)ingredients);
            construct.parts().forEach(ingredient -> {
                class_1814 rarity = CompositeWriter.getRarityFromInt(AttributeHelper.of((State)ingredient).rarity());
                class_5250 mutableText = class_2561.method_43470((String)stringIndent.toString()).method_10852(Writer.nameToTranslatableText(ingredient)).method_27692(rarity.field_8908);
                tooltip.add((class_2561)mutableText);
                if (context.method_8035() && ingredient instanceof Composite) {
                    Composite constructSlot = (Composite)ingredient;
                    CompositeWriter.write(constructSlot, tooltip, context, indent + 2);
                }
            });
        }
    }

    private void writeCompositeWithIndent(List<class_2561> tooltip, class_1836 context, int indent) {
        Constructed construct;
        Composite composite;
        StringBuilder stringIndent = new StringBuilder(" ");
        stringIndent.append(" ".repeat(Math.max(0, indent)));
        if (this.composite.slots().size() > 0) {
            class_5250 slots = class_2561.method_43470((String)stringIndent.toString()).method_10852((class_2561)class_2561.method_43471((String)Writer.toTranslationKey("slots")).method_10852((class_2561)class_2561.method_43470((String)":")).method_27692(class_124.field_1080));
            tooltip.add((class_2561)slots);
            this.composite.slots().forEach(slot -> {
                Object patt4258$temp;
                class_5250 mutableText = class_2561.method_43470((String)(stringIndent + " ")).method_10852((class_2561)class_2561.method_43471((String)Writer.toTranslationKey(slot.identifier().toLowerCase(Locale.ENGLISH))).method_10852((class_2561)class_2561.method_43470((String)": ")).method_27692(class_124.field_1080));
                if (slot.filled()) {
                    class_1814 rarity = CompositeWriter.getRarityFromInt(AttributeHelper.of((State)((State)slot.get().get())).rarity());
                    mutableText.method_10852(Writer.nameToTranslatableText((State)slot.get().get())).method_27692(rarity.field_8908);
                } else if (slot.identifier().equals(slot.typeName().toLowerCase(Locale.ENGLISH))) {
                    mutableText.method_10852((class_2561)class_2561.method_43470((String)"-")).method_27692(class_124.field_1080);
                } else {
                    mutableText.method_10852((class_2561)class_2561.method_43471((String)Writer.toTranslationKey(slot.typeName().toLowerCase(Locale.ENGLISH)))).method_27692(class_124.field_1080);
                }
                tooltip.add((class_2561)mutableText);
                if (context.method_8035() && slot.filled() && (patt4258$temp = slot.get().get()) instanceof Construct) {
                    Construct constructSlot = (Construct)patt4258$temp;
                    CompositeWriter.write((Composite)constructSlot, tooltip, context, indent + 2);
                }
            });
        }
        if ((composite = this.composite) instanceof Constructed && (construct = (Constructed)composite).parts().size() > 0) {
            class_5250 ingredients = class_2561.method_43470((String)stringIndent.toString()).method_10852((class_2561)class_2561.method_43471((String)Writer.toTranslationKey("ingredients"))).method_27693(":").method_27692(class_124.field_1080);
            tooltip.add((class_2561)ingredients);
            construct.parts().forEach(ingredient -> {
                class_1814 rarity = CompositeWriter.getRarityFromInt(AttributeHelper.of((State)ingredient).rarity());
                class_5250 mutableText = class_2561.method_43470((String)(stringIndent + " ")).method_10852(Writer.nameToTranslatableText(ingredient)).method_27692(rarity.field_8908);
                tooltip.add((class_2561)mutableText);
                if (context.method_8035() && ingredient instanceof Composite) {
                    Composite constructSlot = (Composite)ingredient;
                    CompositeWriter.write(constructSlot, tooltip, context, indent + 2);
                }
            });
        }
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
        this.writeCompositeWithIndent(tooltip, context, 0);
    }
}

