/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip;

import com.sigmundgranaas.forgero.core.soul.Soul;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.Writer;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.AttributeWriterHelper;
import java.text.NumberFormat;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class SoulWriter
implements Writer {
    private final Soul soul;

    public SoulWriter(Soul soul) {
        this.soul = soul;
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
        String name = this.soul.name();
        int level = this.soul.getLevel();
        float currentXp = this.soul.getXp();
        int xpTarget = this.soul.getXpTarget();
        float percentage = currentXp / (float)xpTarget;
        this.writeSoulInfo(name, level, tooltip);
        this.writeXpBar(percentage, tooltip);
    }

    private void writeSoulInfo(String name, int level, List<class_2561> tooltip) {
        class_5250 header = class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"item.forgero.soul").method_27692(class_124.field_1080));
        class_5250 info = class_2561.method_43470((String)String.format("  %s, Level %s", name, level));
        tooltip.add((class_2561)header);
        tooltip.add((class_2561)info);
    }

    private void writeXpBar(float percentage, List<class_2561> tooltip) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(2);
        String convertBarsToX = IntStream.range(0, 9).mapToObj(i -> percentage > (float)i / 10.0f ? "X" : "-").reduce("", String::concat);
        String xpBar = String.format("  xp: [%s]", convertBarsToX);
        class_5250 xpText = class_2561.method_43470((String)xpBar).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)(" " + AttributeWriterHelper.roundFloat(percentage * 100.0f) + "%")));
        tooltip.add((class_2561)xpText);
    }
}

