/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip;

import com.sigmundgranaas.forgero.core.condition.Conditional;
import com.sigmundgranaas.forgero.core.soul.SoulContainer;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.CachedWriteHelper;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.CompositeWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.ConditionWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.SoulWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.Writer;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.DefaultWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.ToolWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.writer.PartWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.writer.SchematicWriter;
import java.util.List;
import net.minecraft.class_1836;
import net.minecraft.class_2561;

public class StateWriter
implements Writer {
    protected final State state;

    public StateWriter(State state) {
        this.state = state;
    }

    public static Writer of(State state) {
        Writer writer = state.test((Matchable)Type.TOOL) || state.test((Matchable)Type.SWORD) ? new ToolWriter(state) : (state.test((Matchable)Type.PART) ? new PartWriter(state) : (state.test((Matchable)Type.SCHEMATIC) ? new SchematicWriter(state) : new DefaultWriter(state)));
        return CachedWriteHelper.of(state, writer);
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
        State state = this.state;
        if (state instanceof SoulContainer) {
            SoulContainer container = (SoulContainer)state;
            new SoulWriter(container.getSoul()).write(tooltip, context);
        }
        if ((state = this.state) instanceof Composite) {
            Composite composite = (Composite)state;
            new CompositeWriter(composite).write(tooltip, context);
        }
        if ((state = this.state) instanceof Conditional) {
            Conditional conditional = (Conditional)state;
            new ConditionWriter(conditional).write(tooltip, context);
        }
    }
}

