/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip.v2;

import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.AttackSpeed;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.AttributeHelper;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.BaseWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.PredicateWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.PredicateWriterFactory;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TagWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TooltipConfiguration;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.difference.DifferenceHelper;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class AttributeWriterHelper
extends BaseWriter {
    private final PropertyContainer container;
    private final AttributeHelper helper;
    private final TooltipConfiguration configuration;
    private final DifferenceHelper differenceHelper = new DifferenceHelper();
    @Nullable
    private PropertyContainer comparativeContainer;

    public AttributeWriterHelper(PropertyContainer container, TooltipConfiguration configuration) {
        this.container = container;
        this.helper = new AttributeHelper(container);
        this.configuration = configuration;
    }

    public static String number(float attribute) {
        if ((float)Math.round(attribute) == attribute || AttributeWriterHelper.roundFloat(attribute) == (float)Math.round(attribute)) {
            return String.valueOf(Math.round(attribute));
        }
        return String.valueOf(AttributeWriterHelper.roundFloat(attribute));
    }

    public static float roundFloat(float number) {
        NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
        format.setMaximumFractionDigits(2);
        try {
            return Float.parseFloat(format.format(number));
        }
        catch (NumberFormatException e) {
            return 1.0f;
        }
    }

    public void setComparativeContainer(@Nullable PropertyContainer comparativeContainer) {
        this.comparativeContainer = comparativeContainer;
    }

    public class_5250 writePercentageAttribute(Attribute attribute) {
        return this.writeAttributeType(attribute.type()).method_10852((class_2561)AttributeWriterHelper.indented(1)).method_10852((class_2561)this.percentageNumberText(attribute));
    }

    public class_5250 writeBaseNumber(Attribute attribute) {
        float value = attribute.leveledValue();
        if (attribute.getAttributeType().equals(AttackSpeed.KEY) && (this.isPartHead(this.container) || this.isSchematic(this.container) && value < -1.0f)) {
            value = 4.0f + value;
        }
        return this.writeAttributeType(attribute.type()).method_10852((class_2561)AttributeWriterHelper.indented(1)).method_27693(AttributeWriterHelper.number(value));
    }

    private boolean isPartHead(Object o) {
        Matchable matchable;
        return o instanceof Matchable && ((matchable = (Matchable)o).test((Matchable)Type.SWORD_BLADE) || matchable.test((Matchable)Type.TOOL_PART_HEAD));
    }

    private boolean isSchematic(Object o) {
        Matchable matchable;
        return o instanceof Matchable && (matchable = (Matchable)o).test((Matchable)Type.SCHEMATIC);
    }

    public class_5250 writeBaseNumber(ComputedAttribute attribute) {
        float value = attribute.asFloat().floatValue();
        if (attribute.key().equals(AttackSpeed.KEY) && this.isPartHead(this.container)) {
            value = 4.0f + value;
        }
        if (this.comparativeContainer != null) {
            ComputedAttribute comparativeAttribute = new AttributeHelper(this.comparativeContainer).apply(attribute.key());
            if (!attribute.asFloat().equals(comparativeAttribute.asFloat())) {
                float difference = attribute.asFloat().floatValue() - comparativeAttribute.asFloat().floatValue();
                return this.writeAttributeType(attribute.key()).method_10852((class_2561)AttributeWriterHelper.indented(1)).method_10852((class_2561)class_2561.method_43470((String)AttributeWriterHelper.number(value)).method_10852((class_2561)this.differenceHelper.getDifferenceMarker(difference, attribute.key())).method_27692(this.differenceHelper.getDifferenceFormatting(difference, attribute.key())));
            }
        }
        return this.writeAttributeType(attribute.key()).method_10852((class_2561)AttributeWriterHelper.indented(1)).method_27693(AttributeWriterHelper.number(value));
    }

    public class_5250 writeMultiplicativeAttribute(Attribute attribute) {
        return this.writeAttributeType(attribute.type()).method_10852((class_2561)AttributeWriterHelper.indented(1)).method_10852((class_2561)this.multiplicativeNumberText(attribute));
    }

    public class_5250 writeAdditionAttribute(Attribute attribute) {
        float value = attribute.leveledValue();
        if (attribute.getAttributeType().equals(AttackSpeed.KEY)) {
            value = 4.0f + value;
        }
        return this.writeAttributeType(attribute.type()).method_10852((class_2561)AttributeWriterHelper.indented(1)).method_10852((class_2561)this.additionSign(value)).method_27693(AttributeWriterHelper.number(attribute.leveledValue()));
    }

    public class_5250 multiplicativeNumberText(Attribute attribute) {
        float value = attribute.leveledValue();
        return class_2561.method_43470((String)AttributeWriterHelper.number(value)).method_10852(this.translatableMultiplier());
    }

    public class_5250 percentageNumberText(Attribute attribute) {
        String percentage = AttributeWriterHelper.number(attribute.leveledValue() * 100.0f - 100.0f);
        return this.multiplicativeSign(attribute.leveledValue()).method_10852((class_2561)class_2561.method_43470((String)(percentage + "%")));
    }

    public List<class_5250> writeTarget(Attribute attribute) {
        Optional<PredicateWriter> writer = new PredicateWriterFactory().build(attribute.getPredicate(), this.configuration);
        if (attribute.getPredicate() == Matchable.DEFAULT_TRUE) {
            return Collections.emptyList();
        }
        if (writer.isPresent()) {
            return writer.get().write(attribute.getPredicate());
        }
        class_5250 against = AttributeWriterHelper.indented(this.configuration.baseIndent() + 2).method_10852((class_2561)class_2561.method_43471((String)"tooltip.forgero.against").method_27692(class_124.field_1080));
        against.method_10852((class_2561)TagWriter.writeTagList(attribute.targets()));
        return List.of(against);
    }

    private class_5250 multiplicativeSign(float value) {
        if (value >= 1.0f) {
            return class_2561.method_43470((String)"+");
        }
        return class_2561.method_43470((String)"");
    }

    private class_5250 additionSign(float value) {
        if (value >= 0.0f) {
            return class_2561.method_43470((String)"+");
        }
        return class_2561.method_43470((String)"");
    }

    public class_2561 translatableMultiplier() {
        return class_2561.method_43471((String)"tooltip.forgero.attribute.multiplier");
    }

    public class_5250 writeAttributeType(String attribute) {
        return AttributeWriterHelper.indented(this.configuration.baseIndent() + 1).method_10852((class_2561)this.writeTranslatableAttributeType(attribute).method_27692(this.neutral())).method_10852((class_2561)this.sectionSeparator().method_27692(this.neutral()));
    }

    public class_5250 writeTranslatableAttributeType(String type) {
        return class_2561.method_43471((String)String.format("tooltip.forgero.attribute.%s", type.toLowerCase(Locale.ENGLISH)));
    }

    public Stream<Attribute> attributesOfType(String type) {
        return this.container.stream().getAttributes().filter(attribute -> attribute.type().equals(type));
    }

    public ComputedAttribute attributeOfType(String type) {
        return this.helper.apply(type);
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
    }

    private class_5250 sectionSeparator() {
        return class_2561.method_43471((String)"tooltip.forgero.section.section_separator");
    }
}

