/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip.v2;

import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TooltipAttributeRegistry {
    private static final Map<Type, List<String>> FILTERS = new ConcurrentHashMap<Type, List<String>>();
    private static final Map<String, Predicate<PropertyContainer>> ATTRIBUTE_CONDITIONS = new ConcurrentHashMap<String, Predicate<PropertyContainer>>();

    private TooltipAttributeRegistry() {
    }

    public static FilterBuilder filterBuilder() {
        return new FilterBuilder();
    }

    public static AttributeBuilder attributeBuilder() {
        return new AttributeBuilder();
    }

    public static List<String> getFilterForType(Type type) {
        return FILTERS.entrySet().stream().filter(entry -> type.test((Matchable)entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream()).distinct().collect(Collectors.toList());
    }

    public static List<String> getWritableAttributes(PropertyContainer container) {
        return ATTRIBUTE_CONDITIONS.entrySet().stream().filter(entry -> ((Predicate)entry.getValue()).test(container)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static final class FilterBuilder {
        private Type type;
        private List<String> attributes;

        private FilterBuilder() {
        }

        public FilterBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public FilterBuilder attributes(List<String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public void register() {
            if (this.type == null || this.attributes == null) {
                throw new IllegalStateException("Both type and attributes must be set before registering");
            }
            FILTERS.merge(this.type, this.attributes, (oldAttributes, newAttributes) -> {
                ArrayList combinedAttributes = new ArrayList(oldAttributes);
                combinedAttributes.addAll(newAttributes);
                return combinedAttributes.stream().distinct().collect(Collectors.toList());
            });
        }
    }

    public static final class AttributeBuilder {
        private String attribute;
        private Predicate<PropertyContainer> condition = container -> true;

        private AttributeBuilder() {
        }

        public AttributeBuilder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public AttributeBuilder condition(Predicate<PropertyContainer> condition) {
            this.condition = condition;
            return this;
        }

        public void register() {
            if (this.attribute == null) {
                throw new IllegalStateException("Attribute must be set before registering");
            }
            ATTRIBUTE_CONDITIONS.put(this.attribute, this.condition);
        }
    }
}

