/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip.v2;

import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TooltipAttributeRegistry;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TooltipConfiguration {
    private boolean hideSectionTitle;
    private int baseIndent;
    private int sectionOrder;
    private boolean hideZeroValues;
    private boolean showExtendedInfo;
    private boolean showDetailedInfo;
    private Set<Category> upgradeCategories;
    private Set<String> hiddenFeatureTypes;
    private boolean padded;

    public List<String> writableAttributes(PropertyContainer container) {
        return this.filteredAttributes(container).orElseGet(() -> TooltipAttributeRegistry.getWritableAttributes(container));
    }

    public Optional<List<String>> filteredAttributes(PropertyContainer container) {
        if (container instanceof State) {
            State state = (State)container;
            return Optional.of(TooltipAttributeRegistry.getFilterForType(state.type())).filter(collection -> !collection.isEmpty());
        }
        return Optional.empty();
    }

    private static boolean $default$hideSectionTitle() {
        return false;
    }

    private static int $default$baseIndent() {
        return 0;
    }

    private static int $default$sectionOrder() {
        return 0;
    }

    private static boolean $default$hideZeroValues() {
        return true;
    }

    private static boolean $default$showExtendedInfo() {
        return false;
    }

    private static boolean $default$showDetailedInfo() {
        return false;
    }

    private static Set<Category> $default$upgradeCategories() {
        return Category.UPGRADE_CATEGORIES;
    }

    private static Set<String> $default$hiddenFeatureTypes() {
        return Set.of("EFFECTIVE_BLOCKS");
    }

    private static boolean $default$padded() {
        return false;
    }

    TooltipConfiguration(boolean hideSectionTitle, int baseIndent, int sectionOrder, boolean hideZeroValues, boolean showExtendedInfo, boolean showDetailedInfo, Set<Category> upgradeCategories, Set<String> hiddenFeatureTypes, boolean padded) {
        this.hideSectionTitle = hideSectionTitle;
        this.baseIndent = baseIndent;
        this.sectionOrder = sectionOrder;
        this.hideZeroValues = hideZeroValues;
        this.showExtendedInfo = showExtendedInfo;
        this.showDetailedInfo = showDetailedInfo;
        this.upgradeCategories = upgradeCategories;
        this.hiddenFeatureTypes = hiddenFeatureTypes;
        this.padded = padded;
    }

    public static TooltipConfigurationBuilder builder() {
        return new TooltipConfigurationBuilder();
    }

    public TooltipConfigurationBuilder toBuilder() {
        return new TooltipConfigurationBuilder().hideSectionTitle(this.hideSectionTitle).baseIndent(this.baseIndent).sectionOrder(this.sectionOrder).hideZeroValues(this.hideZeroValues).showExtendedInfo(this.showExtendedInfo).showDetailedInfo(this.showDetailedInfo).upgradeCategories(this.upgradeCategories).hiddenFeatureTypes(this.hiddenFeatureTypes).padded(this.padded);
    }

    public boolean hideSectionTitle() {
        return this.hideSectionTitle;
    }

    public int baseIndent() {
        return this.baseIndent;
    }

    public int sectionOrder() {
        return this.sectionOrder;
    }

    public boolean hideZeroValues() {
        return this.hideZeroValues;
    }

    public boolean showExtendedInfo() {
        return this.showExtendedInfo;
    }

    public boolean showDetailedInfo() {
        return this.showDetailedInfo;
    }

    public Set<Category> upgradeCategories() {
        return this.upgradeCategories;
    }

    public Set<String> hiddenFeatureTypes() {
        return this.hiddenFeatureTypes;
    }

    public boolean padded() {
        return this.padded;
    }

    public TooltipConfiguration hideSectionTitle(boolean hideSectionTitle) {
        this.hideSectionTitle = hideSectionTitle;
        return this;
    }

    public TooltipConfiguration baseIndent(int baseIndent) {
        this.baseIndent = baseIndent;
        return this;
    }

    public TooltipConfiguration sectionOrder(int sectionOrder) {
        this.sectionOrder = sectionOrder;
        return this;
    }

    public TooltipConfiguration hideZeroValues(boolean hideZeroValues) {
        this.hideZeroValues = hideZeroValues;
        return this;
    }

    public TooltipConfiguration showExtendedInfo(boolean showExtendedInfo) {
        this.showExtendedInfo = showExtendedInfo;
        return this;
    }

    public TooltipConfiguration showDetailedInfo(boolean showDetailedInfo) {
        this.showDetailedInfo = showDetailedInfo;
        return this;
    }

    public TooltipConfiguration upgradeCategories(Set<Category> upgradeCategories) {
        this.upgradeCategories = upgradeCategories;
        return this;
    }

    public TooltipConfiguration hiddenFeatureTypes(Set<String> hiddenFeatureTypes) {
        this.hiddenFeatureTypes = hiddenFeatureTypes;
        return this;
    }

    public TooltipConfiguration padded(boolean padded) {
        this.padded = padded;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TooltipConfiguration)) {
            return false;
        }
        TooltipConfiguration other = (TooltipConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.hideSectionTitle() != other.hideSectionTitle()) {
            return false;
        }
        if (this.baseIndent() != other.baseIndent()) {
            return false;
        }
        if (this.sectionOrder() != other.sectionOrder()) {
            return false;
        }
        if (this.hideZeroValues() != other.hideZeroValues()) {
            return false;
        }
        if (this.showExtendedInfo() != other.showExtendedInfo()) {
            return false;
        }
        if (this.showDetailedInfo() != other.showDetailedInfo()) {
            return false;
        }
        if (this.padded() != other.padded()) {
            return false;
        }
        Set<Category> this$upgradeCategories = this.upgradeCategories();
        Set<Category> other$upgradeCategories = other.upgradeCategories();
        if (this$upgradeCategories == null ? other$upgradeCategories != null : !((Object)this$upgradeCategories).equals(other$upgradeCategories)) {
            return false;
        }
        Set<String> this$hiddenFeatureTypes = this.hiddenFeatureTypes();
        Set<String> other$hiddenFeatureTypes = other.hiddenFeatureTypes();
        return !(this$hiddenFeatureTypes == null ? other$hiddenFeatureTypes != null : !((Object)this$hiddenFeatureTypes).equals(other$hiddenFeatureTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TooltipConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hideSectionTitle() ? 79 : 97);
        result = result * 59 + this.baseIndent();
        result = result * 59 + this.sectionOrder();
        result = result * 59 + (this.hideZeroValues() ? 79 : 97);
        result = result * 59 + (this.showExtendedInfo() ? 79 : 97);
        result = result * 59 + (this.showDetailedInfo() ? 79 : 97);
        result = result * 59 + (this.padded() ? 79 : 97);
        Set<Category> $upgradeCategories = this.upgradeCategories();
        result = result * 59 + ($upgradeCategories == null ? 43 : ((Object)$upgradeCategories).hashCode());
        Set<String> $hiddenFeatureTypes = this.hiddenFeatureTypes();
        result = result * 59 + ($hiddenFeatureTypes == null ? 43 : ((Object)$hiddenFeatureTypes).hashCode());
        return result;
    }

    public String toString() {
        return "TooltipConfiguration(hideSectionTitle=" + this.hideSectionTitle() + ", baseIndent=" + this.baseIndent() + ", sectionOrder=" + this.sectionOrder() + ", hideZeroValues=" + this.hideZeroValues() + ", showExtendedInfo=" + this.showExtendedInfo() + ", showDetailedInfo=" + this.showDetailedInfo() + ", upgradeCategories=" + this.upgradeCategories() + ", hiddenFeatureTypes=" + this.hiddenFeatureTypes() + ", padded=" + this.padded() + ")";
    }

    public static class TooltipConfigurationBuilder {
        private boolean hideSectionTitle$set;
        private boolean hideSectionTitle$value;
        private boolean baseIndent$set;
        private int baseIndent$value;
        private boolean sectionOrder$set;
        private int sectionOrder$value;
        private boolean hideZeroValues$set;
        private boolean hideZeroValues$value;
        private boolean showExtendedInfo$set;
        private boolean showExtendedInfo$value;
        private boolean showDetailedInfo$set;
        private boolean showDetailedInfo$value;
        private boolean upgradeCategories$set;
        private Set<Category> upgradeCategories$value;
        private boolean hiddenFeatureTypes$set;
        private Set<String> hiddenFeatureTypes$value;
        private boolean padded$set;
        private boolean padded$value;

        TooltipConfigurationBuilder() {
        }

        public TooltipConfigurationBuilder hideSectionTitle(boolean hideSectionTitle) {
            this.hideSectionTitle$value = hideSectionTitle;
            this.hideSectionTitle$set = true;
            return this;
        }

        public TooltipConfigurationBuilder baseIndent(int baseIndent) {
            this.baseIndent$value = baseIndent;
            this.baseIndent$set = true;
            return this;
        }

        public TooltipConfigurationBuilder sectionOrder(int sectionOrder) {
            this.sectionOrder$value = sectionOrder;
            this.sectionOrder$set = true;
            return this;
        }

        public TooltipConfigurationBuilder hideZeroValues(boolean hideZeroValues) {
            this.hideZeroValues$value = hideZeroValues;
            this.hideZeroValues$set = true;
            return this;
        }

        public TooltipConfigurationBuilder showExtendedInfo(boolean showExtendedInfo) {
            this.showExtendedInfo$value = showExtendedInfo;
            this.showExtendedInfo$set = true;
            return this;
        }

        public TooltipConfigurationBuilder showDetailedInfo(boolean showDetailedInfo) {
            this.showDetailedInfo$value = showDetailedInfo;
            this.showDetailedInfo$set = true;
            return this;
        }

        public TooltipConfigurationBuilder upgradeCategories(Set<Category> upgradeCategories) {
            this.upgradeCategories$value = upgradeCategories;
            this.upgradeCategories$set = true;
            return this;
        }

        public TooltipConfigurationBuilder hiddenFeatureTypes(Set<String> hiddenFeatureTypes) {
            this.hiddenFeatureTypes$value = hiddenFeatureTypes;
            this.hiddenFeatureTypes$set = true;
            return this;
        }

        public TooltipConfigurationBuilder padded(boolean padded) {
            this.padded$value = padded;
            this.padded$set = true;
            return this;
        }

        public TooltipConfiguration build() {
            boolean hideSectionTitle$value = this.hideSectionTitle$value;
            if (!this.hideSectionTitle$set) {
                hideSectionTitle$value = TooltipConfiguration.$default$hideSectionTitle();
            }
            int baseIndent$value = this.baseIndent$value;
            if (!this.baseIndent$set) {
                baseIndent$value = TooltipConfiguration.$default$baseIndent();
            }
            int sectionOrder$value = this.sectionOrder$value;
            if (!this.sectionOrder$set) {
                sectionOrder$value = TooltipConfiguration.$default$sectionOrder();
            }
            boolean hideZeroValues$value = this.hideZeroValues$value;
            if (!this.hideZeroValues$set) {
                hideZeroValues$value = TooltipConfiguration.$default$hideZeroValues();
            }
            boolean showExtendedInfo$value = this.showExtendedInfo$value;
            if (!this.showExtendedInfo$set) {
                showExtendedInfo$value = TooltipConfiguration.$default$showExtendedInfo();
            }
            boolean showDetailedInfo$value = this.showDetailedInfo$value;
            if (!this.showDetailedInfo$set) {
                showDetailedInfo$value = TooltipConfiguration.$default$showDetailedInfo();
            }
            Set<Category> upgradeCategories$value = this.upgradeCategories$value;
            if (!this.upgradeCategories$set) {
                upgradeCategories$value = TooltipConfiguration.$default$upgradeCategories();
            }
            Set<String> hiddenFeatureTypes$value = this.hiddenFeatureTypes$value;
            if (!this.hiddenFeatureTypes$set) {
                hiddenFeatureTypes$value = TooltipConfiguration.$default$hiddenFeatureTypes();
            }
            boolean padded$value = this.padded$value;
            if (!this.padded$set) {
                padded$value = TooltipConfiguration.$default$padded();
            }
            return new TooltipConfiguration(hideSectionTitle$value, baseIndent$value, sectionOrder$value, hideZeroValues$value, showExtendedInfo$value, showDetailedInfo$value, upgradeCategories$value, hiddenFeatureTypes$value, padded$value);
        }

        public String toString() {
            return "TooltipConfiguration.TooltipConfigurationBuilder(hideSectionTitle$value=" + this.hideSectionTitle$value + ", baseIndent$value=" + this.baseIndent$value + ", sectionOrder$value=" + this.sectionOrder$value + ", hideZeroValues$value=" + this.hideZeroValues$value + ", showExtendedInfo$value=" + this.showExtendedInfo$value + ", showDetailedInfo$value=" + this.showDetailedInfo$value + ", upgradeCategories$value=" + this.upgradeCategories$value + ", hiddenFeatureTypes$value=" + this.hiddenFeatureTypes$value + ", padded$value=" + this.padded$value + ")";
        }
    }
}

