/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.context.Contexts;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.AttributeWriterHelper;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TooltipConfiguration;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section.SectionWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1836;
import net.minecraft.class_2561;

public class AttributeSectionWriter
extends SectionWriter {
    private static final String sectionTranslationKey = "attributes";
    private final PropertyContainer container;
    private final AttributeWriterHelper helper;

    public AttributeSectionWriter(PropertyContainer container, TooltipConfiguration configuration) {
        super(configuration);
        this.container = container;
        this.helper = new AttributeWriterHelper(container, configuration);
        if (container instanceof State) {
            State state = (State)container;
            if (ForgeroStateRegistry.STATES != null) {
                this.helper.setComparativeContainer((PropertyContainer)state.strip());
            }
        }
    }

    public static Optional<SectionWriter> of(PropertyContainer container) {
        return AttributeSectionWriter.of(container, TooltipConfiguration.builder().build());
    }

    public static Optional<SectionWriter> of(PropertyContainer container, TooltipConfiguration configuration) {
        AttributeSectionWriter writer = new AttributeSectionWriter(container, configuration);
        if (writer.shouldWrite()) {
            return Optional.of(writer);
        }
        return Optional.empty();
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
        tooltip.add(this.createSection(sectionTranslationKey));
        tooltip.addAll(this.entries());
        super.write(tooltip, context);
    }

    @Override
    public boolean shouldWrite() {
        return !this.entries().isEmpty();
    }

    @Override
    public int getSectionOrder() {
        return 1;
    }

    @Override
    public List<class_2561> entries() {
        return this.configuration.writableAttributes(this.container).stream().map(this::entry).flatMap(Collection::stream).toList();
    }

    protected List<class_2561> entry(String attributeType) {
        Optional<Attribute> attributeOpt = this.helper.attributesOfType(attributeType).filter(attribute -> attribute.getContext().test((Matchable)Contexts.UNDEFINED)).findFirst();
        if (attributeOpt.isPresent()) {
            if (this.shouldIgnoreAttribute(attributeOpt.get())) {
                return Collections.emptyList();
            }
            ComputedAttribute attribute2 = ComputedAttribute.of((PropertyContainer)this.container, (String)attributeType);
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)this.helper.writeBaseNumber(attribute2));
            builder.addAll(this.helper.writeTarget(attributeOpt.get()));
            return builder.build();
        }
        return Collections.emptyList();
    }

    private boolean shouldIgnoreAttribute(Attribute attribute) {
        if (this.configuration.hideZeroValues() && !this.configuration.showDetailedInfo() && attribute.leveledValue() == 0.0f) {
            return true;
        }
        return attribute.getAttributeType().equals("forgero:reach") && (double)attribute.getValue() == 4.5;
    }
}

