/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.context.Contexts;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.NumericOperation;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.attribute.BaseAttribute;
import com.sigmundgranaas.forgero.core.state.composite.Constructed;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.AttributeWriterHelper;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TooltipConfiguration;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section.SectionWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1836;
import net.minecraft.class_2561;

public class BaseAttributeSectionWriter
extends SectionWriter {
    private static final String sectionTranslationKey = "base_attributes";
    private final PropertyContainer container;
    private final AttributeWriterHelper helper;

    public BaseAttributeSectionWriter(PropertyContainer container, TooltipConfiguration configuration) {
        super(configuration);
        this.container = container;
        this.helper = new AttributeWriterHelper(container, configuration);
    }

    public static Optional<SectionWriter> of(PropertyContainer container) {
        return BaseAttributeSectionWriter.of(container, TooltipConfiguration.builder().build());
    }

    public static Optional<SectionWriter> of(PropertyContainer container, TooltipConfiguration configuration) {
        BaseAttributeSectionWriter writer = new BaseAttributeSectionWriter(container, configuration);
        if (writer.shouldWrite()) {
            return Optional.of(writer);
        }
        return Optional.empty();
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
        tooltip.add(this.createSection(sectionTranslationKey));
        tooltip.addAll(this.entries());
        super.write(tooltip, context);
    }

    @Override
    public boolean shouldWrite() {
        return this.container.stream().getAttributes().anyMatch(attribute -> attribute.getContext().test((Matchable)Contexts.COMPOSITE)) && !(this.container instanceof Constructed) && !this.entries().isEmpty();
    }

    @Override
    public int getSectionOrder() {
        return 1;
    }

    @Override
    public List<class_2561> entries() {
        return this.configuration.writableAttributes(this.container).stream().map(this::entry).flatMap(Collection::stream).toList();
    }

    protected List<class_2561> entry(String attributeType) {
        List compressible = this.helper.attributesOfType(attributeType).filter(attribute -> attribute.getContext().value().equals(Contexts.COMPOSITE.value())).sorted(Attribute::compareTo).filter(attribute -> attribute.getPredicate().equals(Matchable.DEFAULT_TRUE)).reduce(this::combine).map(List::of).orElse(Collections.emptyList());
        List<Attribute> uniques = this.helper.attributesOfType(attributeType).filter(attribute -> attribute.getContext().value().equals(Contexts.COMPOSITE.value())).filter(attribute -> !attribute.getPredicate().equals(Matchable.DEFAULT_TRUE)).sorted(Attribute::compareTo).toList();
        return Stream.concat(compressible.stream(), uniques.stream()).filter(attribute -> attribute.getContext().test((Matchable)Contexts.COMPOSITE)).filter(att -> att.leveledValue() != 0.0f).sorted(Attribute::compareTo).map(this::attributeEntry).flatMap(Collection::stream).toList();
    }

    protected List<class_2561> attributeEntry(Attribute attribute) {
        if (attribute.getOperation() == NumericOperation.MULTIPLICATION) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)this.helper.writeMultiplicativeAttribute(attribute));
            builder.addAll(this.helper.writeTarget(attribute));
            return builder.build();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.helper.writeBaseNumber(attribute));
        builder.addAll(this.helper.writeTarget(attribute));
        return builder.build();
    }

    private Attribute combine(Attribute a1, Attribute a2) {
        if (a1.getOperation() == a2.getOperation()) {
            if (a1.getOperation() == NumericOperation.MULTIPLICATION) {
                return new BaseAttribute(a1.getAttributeType(), NumericOperation.MULTIPLICATION, a1.leveledValue() * a2.leveledValue(), a1.getPredicate(), a1.getOrder(), a1.getLevel(), a1.getCategory(), a1.getId() + a2.getId(), a1.targets(), a1.targetType(), a1.getPriority(), a1.getContext(), (PropertyContainer)a1.source().orElse(null));
            }
            return new BaseAttribute(a1.getAttributeType(), NumericOperation.ADDITION, a1.leveledValue() + a2.leveledValue(), a1.getPredicate(), a1.getOrder(), a1.getLevel(), a1.getCategory(), a1.getId() + a2.getId(), a1.targets(), a1.targetType(), a1.getPriority(), a1.getContext(), (PropertyContainer)a1.source().orElse(null));
        }
        return new BaseAttribute(a1.getAttributeType(), NumericOperation.ADDITION, a1.leveledValue() * a2.leveledValue(), a1.getPredicate(), a1.getOrder(), a1.getLevel(), a1.getCategory(), a1.getId() + a2.getId(), a1.targets(), a1.targetType(), a1.getPriority(), a1.getContext(), (PropertyContainer)a1.source().orElse(null));
    }
}

