/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section;

import com.sigmundgranaas.forgero.core.condition.Conditional;
import com.sigmundgranaas.forgero.core.condition.NamedCondition;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TooltipConfiguration;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section.SectionWriter;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1836;
import net.minecraft.class_2561;

public class ConditionSectionWriter
extends SectionWriter {
    private final Conditional<?> container;

    public ConditionSectionWriter(Conditional<?> container, TooltipConfiguration configuration) {
        super(configuration);
        this.container = container;
    }

    public static Optional<SectionWriter> of(PropertyContainer container) {
        return ConditionSectionWriter.of(container, TooltipConfiguration.builder().build());
    }

    public static Optional<SectionWriter> of(PropertyContainer container, TooltipConfiguration configuration) {
        Conditional conditional;
        ConditionSectionWriter writer;
        if (container instanceof Conditional && (writer = new ConditionSectionWriter(conditional = (Conditional)container, configuration)).shouldWrite()) {
            return Optional.of(writer);
        }
        return Optional.empty();
    }

    @Override
    public boolean shouldWrite() {
        return !this.container.namedConditions(this.container.compoundedConditions()).isEmpty();
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
        if (!this.configuration.hideSectionTitle()) {
            tooltip.add(this.createSection("conditions"));
        }
        tooltip.addAll(this.entries());
        super.write(tooltip, context);
    }

    @Override
    public int getSectionOrder() {
        return 0;
    }

    @Override
    public List<class_2561> entries() {
        return this.container.namedConditions(this.container.compoundedConditions()).stream().map(this::entry).toList();
    }

    public class_2561 entry(NamedCondition data) {
        return ConditionSectionWriter.indented(this.entryIndent()).method_10852((class_2561)class_2561.method_43471((String)String.format("condition.forgero.%s", data.name())));
    }
}

