/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section;

import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.feature.BasePredicateFeature;
import com.sigmundgranaas.forgero.core.property.v2.feature.Feature;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TooltipConfiguration;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.WriterHelper;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section.SectionWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class FeatureSectionWriter
extends SectionWriter {
    private final PropertyContainer container;

    public FeatureSectionWriter(PropertyContainer container, TooltipConfiguration configuration) {
        super(configuration);
        this.container = container;
    }

    public static Optional<SectionWriter> of(PropertyContainer container) {
        return FeatureSectionWriter.of(container, TooltipConfiguration.builder().build());
    }

    public static Optional<SectionWriter> of(PropertyContainer container, TooltipConfiguration configuration) {
        FeatureSectionWriter writer = new FeatureSectionWriter(container, configuration);
        if (writer.shouldWrite()) {
            return Optional.of(writer);
        }
        return Optional.empty();
    }

    @Override
    public boolean shouldWrite() {
        return !this.container.stream().features().toList().isEmpty() && !this.entries().isEmpty();
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
        if (!this.configuration.hideSectionTitle()) {
            tooltip.add(this.createSection("features"));
        }
        tooltip.addAll(this.entries());
        super.write(tooltip, context);
    }

    @Override
    public int getSectionOrder() {
        return 0;
    }

    @Override
    public List<class_2561> entries() {
        TooltipConfiguration featureConfig = !this.configuration.hideSectionTitle() ? this.configuration.baseIndent(1) : this.configuration;
        return this.container.stream().features().distinct().map(feature -> BaseFeatureWriter.of(feature, new WriterHelper(featureConfig))).flatMap(Optional::stream).map(BaseFeatureWriter::write).flatMap(Collection::stream).toList();
    }

    public static class BaseFeatureWriter {
        private final BasePredicateFeature feature;
        private final WriterHelper helper;

        private BaseFeatureWriter(BasePredicateFeature feature, WriterHelper helper) {
            this.feature = feature;
            this.helper = helper;
        }

        public static Optional<BaseFeatureWriter> of(Feature feature, WriterHelper helper) {
            BasePredicateFeature base;
            if (feature instanceof BasePredicateFeature && !(base = (BasePredicateFeature)feature).title().equals(Identifiers.EMPTY_IDENTIFIER)) {
                return Optional.of(new BaseFeatureWriter(base, helper));
            }
            return Optional.empty();
        }

        public List<class_2561> write() {
            ArrayList<class_2561> entries = new ArrayList<class_2561>();
            class_5250 title = this.helper.writeBase().method_10852((class_2561)class_2561.method_43471((String)this.feature.title())).method_27692(this.helper.neutral());
            entries.add((class_2561)title);
            if (!this.feature.description().isEmpty()) {
                this.feature.description().stream().map(item -> this.helper.writeBase().method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)item)).method_27692(this.helper.base())).forEach(entries::add);
            }
            return entries;
        }
    }
}

