/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section;

import com.sigmundgranaas.forgero.core.property.attribute.AttributeHelper;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.Constructed;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.CompositeWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.Writer;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TooltipConfiguration;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section.SectionWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class IngredientSectionWriter
extends SectionWriter {
    private static final String sectionTranslationKey = "ingredients";
    private final Constructed container;

    public IngredientSectionWriter(Constructed container) {
        super(TooltipConfiguration.builder().build());
        this.container = container;
    }

    public static Optional<SectionWriter> of(State container) {
        Constructed constructed;
        IngredientSectionWriter writer;
        if (container instanceof Constructed && (writer = new IngredientSectionWriter(constructed = (Constructed)container)).shouldWrite()) {
            return Optional.of(writer);
        }
        return Optional.empty();
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
        tooltip.add(this.createSection(sectionTranslationKey));
        tooltip.addAll(this.entries());
        super.write(tooltip, context);
    }

    @Override
    public int getSectionOrder() {
        return 0;
    }

    @Override
    public List<class_2561> entries() {
        ArrayList<class_2561> entries = new ArrayList<class_2561>();
        this.container.parts().forEach(ingredient -> {
            class_1814 rarity = CompositeWriter.getRarityFromInt(AttributeHelper.of((State)ingredient).rarity());
            class_5250 mutableText = IngredientSectionWriter.indented(this.entryIndent()).method_10852(Writer.nameToTranslatableText(ingredient)).method_27692(rarity.field_8908);
            entries.add((class_2561)mutableText);
        });
        return entries;
    }

    @Override
    public boolean shouldWrite() {
        return this.container.parts().size() > 0;
    }
}

