/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section;

import com.sigmundgranaas.forgero.core.property.attribute.AttributeHelper;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.Upgradeable;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.CompositeWriter;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.Writer;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TooltipConfiguration;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section.SectionWriter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class SlotSectionWriter
extends SectionWriter {
    private static final String sectionTranslationKey = "slots";
    private final Upgradeable<?> container;

    public SlotSectionWriter(Upgradeable<?> container) {
        super(TooltipConfiguration.builder().build());
        this.container = container;
    }

    public static Optional<SectionWriter> of(State state) {
        Upgradeable upgradeable;
        SlotSectionWriter writer;
        if (state instanceof Upgradeable && (writer = new SlotSectionWriter(upgradeable = (Upgradeable)state)).shouldWrite()) {
            return Optional.of(writer);
        }
        return Optional.empty();
    }

    @Override
    public boolean shouldWrite() {
        return this.container.slots().size() > 0;
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
        tooltip.add(this.createSection(sectionTranslationKey));
        tooltip.addAll(this.entries());
        super.write(tooltip, context);
    }

    @Override
    public int getSectionOrder() {
        return 0;
    }

    @Override
    public List<class_2561> entries() {
        return this.container.slots().stream().filter(slot -> !slot.category().contains(Category.UNDEFINED)).map(slot -> new SlotWriter((Slot)slot, this.configuration)).map(SectionWriter::entries).flatMap(Collection::stream).toList();
    }

    public static class SlotWriter
    extends SectionWriter {
        private final Slot slot;

        public SlotWriter(Slot slot, TooltipConfiguration configuration) {
            super(configuration);
            this.slot = slot;
        }

        @Override
        public List<class_2561> entries() {
            return this.writeSlot(this.slot);
        }

        public List<class_2561> writeSlot(Slot slot) {
            class_5250 mutableText = SlotWriter.indented(this.entryIndent()).method_10852((class_2561)class_2561.method_43471((String)Writer.toTranslationKey(slot.identifier().toLowerCase(Locale.ENGLISH))).method_10852((class_2561)class_2561.method_43470((String)": ")).method_27692(this.neutral()));
            if (slot.filled()) {
                class_1814 rarity = CompositeWriter.getRarityFromInt(AttributeHelper.of((State)((State)slot.get().get())).rarity());
                mutableText.method_10852(Writer.nameToTranslatableText((State)slot.get().get())).method_27692(rarity.field_8908);
            } else {
                if (slot.identifier().equals(slot.typeName().toLowerCase(Locale.ENGLISH))) {
                    mutableText.method_10852((class_2561)class_2561.method_43470((String)"- ")).method_27692(this.base());
                } else {
                    mutableText.method_10852((class_2561)class_2561.method_43471((String)Writer.toTranslationKey(slot.typeName().toLowerCase(Locale.ENGLISH)))).method_10852((class_2561)class_2561.method_43470((String)" - ")).method_27692(this.base());
                }
                mutableText.method_10852((class_2561)class_2561.method_43471((String)String.format("tooltip.forgero.section.%s", ((Category)slot.category().stream().findFirst().get()).toString().toLowerCase(Locale.ENGLISH))).method_27692(this.base()));
            }
            return List.of(mutableText);
        }

        @Override
        public boolean shouldWrite() {
            return true;
        }
    }
}

