/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.NumericOperation;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.AttributeWriterHelper;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.TooltipConfiguration;
import com.sigmundgranaas.forgero.minecraft.common.tooltip.v2.section.SectionWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class UpgradeAttributeSectionWriter
extends SectionWriter {
    public static final Set<Category> UPGRADE_CATEGORIES = Set.of(Category.UTILITY, Category.DEFENSIVE, Category.OFFENSIVE, Category.ALL);
    private static final String sectionTranslationKey = "upgrade_attributes";
    private final AttributeWriterHelper helper;
    private final PropertyContainer container;

    public UpgradeAttributeSectionWriter(PropertyContainer container, TooltipConfiguration configuration) {
        super(configuration);
        this.helper = new AttributeWriterHelper(container, configuration);
        this.container = container;
    }

    public static Optional<SectionWriter> of(PropertyContainer container) {
        return UpgradeAttributeSectionWriter.of(container, TooltipConfiguration.builder().build());
    }

    public static Optional<SectionWriter> of(PropertyContainer container, TooltipConfiguration configuration) {
        UpgradeAttributeSectionWriter writer = new UpgradeAttributeSectionWriter(container, configuration);
        if (writer.shouldWrite()) {
            return Optional.of(writer);
        }
        return Optional.empty();
    }

    @Override
    public void write(List<class_2561> tooltip, class_1836 context) {
        tooltip.add(this.createSection(sectionTranslationKey));
        tooltip.addAll(this.entries());
        super.write(tooltip, context);
    }

    @Override
    public boolean shouldWrite() {
        return this.container.stream().getAttributes().map(Attribute::getCategory).anyMatch(UPGRADE_CATEGORIES::contains);
    }

    @Override
    public int getSectionOrder() {
        return 1;
    }

    @Override
    public List<class_2561> entries() {
        return this.configuration.upgradeCategories().stream().map(this::category).flatMap(Collection::stream).toList();
    }

    protected List<class_2561> category(Category category) {
        List entries = this.configuration.writableAttributes(this.container).stream().map(attribute -> this.entry((String)attribute, category)).flatMap(Collection::stream).toList();
        if (!entries.isEmpty()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            class_5250 section = UpgradeAttributeSectionWriter.indented(1).method_10852(this.createSection(category.toString().toLowerCase(Locale.ENGLISH)));
            if (category != Category.ALL) {
                builder.add((Object)section);
            }
            return builder.addAll(entries).build();
        }
        return Collections.emptyList();
    }

    protected List<class_2561> entry(String attributeType, Category category) {
        return this.helper.attributesOfType(attributeType).filter(attribute -> category.equals((Object)attribute.getCategory())).filter(att -> att.leveledValue() != 0.0f).sorted(Attribute::compareTo).map(this::attributeEntry).flatMap(Collection::stream).toList();
    }

    protected List<class_2561> attributeEntry(Attribute attribute) {
        if (this.configuration.hideZeroValues() && !this.configuration.showDetailedInfo() && attribute.getValue() == 0.0f) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (attribute.getOperation() == NumericOperation.MULTIPLICATION) {
            builder.add((Object)this.helper.writePercentageAttribute(attribute));
            builder.addAll(this.helper.writeTarget(attribute));
        } else {
            builder.add((Object)this.helper.writeAdditionAttribute(attribute));
            builder.addAll(this.helper.writeTarget(attribute));
        }
        return builder.build();
    }
}

