/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class RestoreBackpackCommand {
    private static final SuggestionProvider<class_2168> SUGGESTION_PROVIDER = (context, builder) -> {
        File backpacksFolder = BackpackManager.getBackpackFolder(((class_2168)context.getSource()).method_9225());
        if (backpacksFolder.listFiles() == null) {
            return Suggestions.empty();
        }
        ArrayList backpackEntries = new ArrayList();
        for (File file : backpacksFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"))) {
            if (file.listFiles() == null) continue;
            backpackEntries.addAll(Arrays.stream(file.listFiles()).collect(ArrayList::new, (list, backpack) -> list.add(backpack.getName()), List::addAll));
        }
        return class_2172.method_9264(backpackEntries.stream(), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"tb").requires(player -> player.method_9259(2));
        tbCommand.then(class_2170.method_9247((String)"restore").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"backpack_id", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER).executes(source -> RestoreBackpackCommand.restoreBackpack((class_2168)source.getSource(), StringArgumentType.getString((CommandContext)source, (String)"backpack_id"), class_2186.method_9315((CommandContext)source, (String)"target"))))));
        dispatcher.register(tbCommand);
    }

    public static int restoreBackpack(class_2168 source, String backpackID, class_3222 player) {
        class_1799 backpack = BackpackManager.getBackpack(player, backpackID);
        if (backpack == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Backpack with ID " + backpackID + " not found")));
            return 0;
        }
        if (!player.method_31548().method_7394(backpack)) {
            player.method_7328(backpack, false);
        }
        source.method_9226(() -> class_2561.method_43470((String)("Successfully restored " + player.method_5476().getString() + "'s backpack")), true);
        return 1;
    }
}

