/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.mixin.WorldSavePathMixin;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BackpackManager {
    public static class_5218 BACKPACKS = WorldSavePathMixin.invokeInit("backpacks");

    public static void addBackpack(class_3222 player, class_1799 stack) {
        try {
            LocalDateTime deathTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy-HH.mm.ss");
            String formattedDeathTime = deathTime.format(formatter);
            String datedBackpackName = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().replace(":", ".") + "_" + formattedDeathTime;
            File backpackFile = BackpackManager.getBackpackFile(player, datedBackpackName);
            backpackFile.getParentFile().mkdirs();
            class_2507.method_10630((class_2487)stack.method_7953(new class_2487()), (Path)backpackFile.toPath());
            LogHelper.info("Created new backpack backup file for " + player.method_5476().getString() + " with unique ID " + datedBackpackName, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static class_1799 readBackpack(class_3218 world, String playerName, String backpackId) {
        try {
            class_2487 data = class_2507.method_10633((Path)BackpackManager.getBackpackFile(world, playerName, backpackId).toPath());
            if (data == null) {
                return null;
            }
            return class_1799.method_7915((class_2487)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static class_1799 getBackpack(class_3222 player, String backpackId) {
        File deathFolder = BackpackManager.getBackpackFolder(player.method_51469());
        File[] players = deathFolder.listFiles();
        if (players == null) {
            return null;
        }
        for (File f : players) {
            File[] files;
            if (!f.isDirectory() || (files = f.listFiles((dir, name) -> name.equals(backpackId))) == null || files.length <= 0) continue;
            return BackpackManager.readBackpack(player.method_51469(), f.getName(), backpackId);
        }
        return null;
    }

    public static File getBackpackFile(class_3222 player, String backpackId) {
        return new File(BackpackManager.getPlayerBackpackFolder(player), backpackId);
    }

    public static File getBackpackFile(class_3218 world, String playerName, String backpackId) {
        return new File(BackpackManager.getPlayerBackpackFolder(world, playerName), backpackId);
    }

    public static File getPlayerBackpackFolder(class_3222 player) {
        return new File(BackpackManager.getBackpackFolder(player.method_51469()), player.method_5477().getString());
    }

    public static File getPlayerBackpackFolder(class_3218 world, String playerName) {
        return new File(BackpackManager.getBackpackFolder(world), playerName);
    }

    public static File getBackpackFolder(class_3218 world) {
        return BackpackManager.getWorldFolder(world, BACKPACKS);
    }

    public static File getWorldFolder(class_3218 serverWorld, class_5218 path) {
        return serverWorld.method_8503().method_27050(path).toFile();
    }
}

