/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.emi.trinkets.TrinketsMain;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketEnums;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class SlotLoader
extends class_4080<Map<String, GroupData>>
implements IdentifiableResourceReloadListener {
    public static final SlotLoader INSTANCE = new SlotLoader();
    static final class_2960 ID = new class_2960("trinkets", "slots");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final int FILE_SUFFIX_LENGTH = ".json".length();
    private Map<String, GroupData> slots = new HashMap<String, GroupData>();

    protected Map<String, GroupData> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMap<String, GroupData> map = new HashMap<String, GroupData>();
        String dataType = "slots";
        for (Map.Entry entry : resourceManager.method_41265(dataType, id -> id.method_12832().endsWith(".json")).entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            if (!identifier.method_12836().equals("trinkets")) continue;
            try {
                for (class_3298 resource : (List)entry.getValue()) {
                    InputStreamReader reader = new InputStreamReader(resource.method_14482());
                    JsonObject jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    String path = identifier.method_12832();
                    String[] parsed = path.substring(dataType.length() + 1, path.length() - FILE_SUFFIX_LENGTH).split("/");
                    String groupName = parsed[0];
                    String fileName = parsed[parsed.length - 1];
                    GroupData group = map.computeIfAbsent(groupName, k -> new GroupData());
                    try {
                        if (fileName.equals("group")) {
                            group.read(jsonObject);
                            continue;
                        }
                        SlotData slot = group.slots.computeIfAbsent(fileName, k -> new SlotData());
                        slot.read(jsonObject);
                    }
                    catch (JsonSyntaxException e) {
                        TrinketsMain.LOGGER.error("[trinkets] Syntax error while reading data for " + path);
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                TrinketsMain.LOGGER.error("[trinkets] Unknown IO error while reading slot data!");
                e.printStackTrace();
            }
        }
        return map;
    }

    protected void apply(Map<String, GroupData> loader, class_3300 manager, class_3695 profiler) {
        this.slots = loader;
    }

    public Map<String, GroupData> getSlots() {
        return ImmutableMap.copyOf(this.slots);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    static class GroupData {
        private int slotId = -1;
        private int order = 0;
        private final Map<String, SlotData> slots = new HashMap<String, SlotData>();

        GroupData() {
        }

        void read(JsonObject jsonObject) {
            this.slotId = class_3518.method_15282((JsonObject)jsonObject, (String)"slot_id", (int)this.slotId);
            this.order = class_3518.method_15282((JsonObject)jsonObject, (String)"order", (int)this.order);
        }

        int getSlotId() {
            return this.slotId;
        }

        int getOrder() {
            return this.order;
        }

        SlotData getSlot(String name) {
            return this.slots.get(name);
        }
    }

    static class SlotData {
        private static final Set<class_2960> DEFAULT_QUICK_MOVE_PREDICATES = ImmutableSet.of((Object)new class_2960("trinkets", "all"));
        private static final Set<class_2960> DEFAULT_VALIDATOR_PREDICATES = ImmutableSet.of((Object)new class_2960("trinkets", "tag"));
        private static final Set<class_2960> DEFAULT_TOOLTIP_PREDICATES = ImmutableSet.of((Object)new class_2960("trinkets", "all"));
        private int order = 0;
        private int amount = -1;
        private String icon = "";
        private final Set<String> quickMovePredicates = new HashSet<String>();
        private final Set<String> validatorPredicates = new HashSet<String>();
        private final Set<String> tooltipPredicates = new HashSet<String>();
        private String dropRule = TrinketEnums.DropRule.DEFAULT.toString();

        SlotData() {
        }

        SlotType create(String group, String name) {
            class_2960 finalIcon = new class_2960(this.icon);
            finalIcon = new class_2960(finalIcon.method_12836(), "textures/" + finalIcon.method_12832() + ".png");
            Set<class_2960> finalValidatorPredicates = this.validatorPredicates.stream().map(class_2960::new).collect(Collectors.toSet());
            Set<class_2960> finalQuickMovePredicates = this.quickMovePredicates.stream().map(class_2960::new).collect(Collectors.toSet());
            Set<class_2960> finalTooltipPredicates = this.tooltipPredicates.stream().map(class_2960::new).collect(Collectors.toSet());
            if (finalValidatorPredicates.isEmpty()) {
                finalValidatorPredicates = DEFAULT_VALIDATOR_PREDICATES;
            }
            if (finalQuickMovePredicates.isEmpty()) {
                finalQuickMovePredicates = DEFAULT_QUICK_MOVE_PREDICATES;
            }
            if (finalTooltipPredicates.isEmpty()) {
                finalTooltipPredicates = DEFAULT_TOOLTIP_PREDICATES;
            }
            if (this.amount == -1) {
                this.amount = 1;
            }
            return new SlotType(group, name, this.order, this.amount, finalIcon, finalQuickMovePredicates, finalValidatorPredicates, finalTooltipPredicates, TrinketEnums.DropRule.valueOf(this.dropRule));
        }

        void read(JsonObject jsonObject) {
            JsonArray jsonTooltipPredicates;
            JsonArray jsonValidatorPredicates;
            String jsonDropRule;
            boolean replace = class_3518.method_15258((JsonObject)jsonObject, (String)"replace", (boolean)false);
            this.order = class_3518.method_15282((JsonObject)jsonObject, (String)"order", (int)this.order);
            int jsonAmount = class_3518.method_15282((JsonObject)jsonObject, (String)"amount", (int)this.amount);
            this.amount = replace ? jsonAmount : Math.max(jsonAmount, this.amount);
            this.icon = class_3518.method_15253((JsonObject)jsonObject, (String)"icon", (String)this.icon);
            JsonArray jsonQuickMovePredicates = class_3518.method_15292((JsonObject)jsonObject, (String)"quick_move_predicates", (JsonArray)new JsonArray());
            if (jsonQuickMovePredicates != null) {
                if (replace && jsonQuickMovePredicates.size() > 0) {
                    this.quickMovePredicates.clear();
                }
                for (JsonElement jsonQuickMovePredicate : jsonQuickMovePredicates) {
                    this.quickMovePredicates.add(jsonQuickMovePredicate.getAsString());
                }
            }
            if (TrinketEnums.DropRule.has(jsonDropRule = class_3518.method_15253((JsonObject)jsonObject, (String)"drop_rule", (String)this.dropRule).toUpperCase())) {
                this.dropRule = jsonDropRule;
            }
            if ((jsonValidatorPredicates = class_3518.method_15292((JsonObject)jsonObject, (String)"validator_predicates", (JsonArray)new JsonArray())) != null) {
                if (replace && jsonValidatorPredicates.size() > 0) {
                    this.validatorPredicates.clear();
                }
                for (JsonElement jsonValidatorPredicate : jsonValidatorPredicates) {
                    this.validatorPredicates.add(jsonValidatorPredicate.getAsString());
                }
            }
            if ((jsonTooltipPredicates = class_3518.method_15292((JsonObject)jsonObject, (String)"tooltip_predicates", (JsonArray)new JsonArray())) != null) {
                if (replace && jsonTooltipPredicates.size() > 0) {
                    this.tooltipPredicates.clear();
                }
                for (JsonElement jsonTooltipPredicate : jsonTooltipPredicates) {
                    this.tooltipPredicates.add(jsonTooltipPredicate.getAsString());
                }
            }
        }
    }
}

