/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.components.machines;

import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.client.components.PressableImageButton;
import earth.terrarium.adastra.client.components.base.ContainerWidget;
import earth.terrarium.adastra.client.components.machines.ConfigurationButton;
import earth.terrarium.adastra.client.utils.GuiUtils;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.base.BaseContainerMenu;
import earth.terrarium.adastra.common.menus.slots.InventorySlot;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundResetSideConfigPacket;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

public class SidedConfigWidget
extends ContainerWidget {
    private final BaseContainerMenu<? extends ContainerMachineBlockEntity> menu;
    private final ContainerMachineBlockEntity entity;
    private int index;

    public SidedConfigWidget(int x, int y, int width, int height, BaseContainerMenu<? extends ContainerMachineBlockEntity> menu) {
        super(x, y, width, height);
        this.menu = menu;
        this.entity = menu.getEntity();
        this.init();
        this.setActive(false);
    }

    public void init() {
        this.renderables.clear();
        this.children.clear();
        if (this.index >= this.entity.getSideConfig().size()) {
            this.index = 0;
        } else if (this.index < 0) {
            this.index = this.entity.getSideConfig().size() - 1;
        } else if (this.entity.getSideConfig().isEmpty()) {
            return;
        }
        SideConfigButtons buttons = this.createSideButtons(this.index);
        this.addRenderableWidget(new PressableImageButton(this.method_46426(), this.method_46427(), 18, 18, GuiUtils.RESET_BUTTON_SPRITES, button -> {
            this.entity.resetToDefault(this.index);
            NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundResetSideConfigPacket(this.entity.method_11016(), this.index));
            this.init();
        })).method_47400(class_7919.method_47407((class_2561)ConstantComponents.RESET_TO_DEFAULT));
        buttons.center(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
    }

    private SideConfigButtons createSideButtons(int i) {
        class_7845 layout = new class_7845().method_48637(3);
        ConfigurationEntry entry = this.entity.getSideConfig().get(i);
        for (Map.Entry<class_2350, Configuration> side : entry.sides().entrySet()) {
            ConfigurationButton button = new ConfigurationButton(this.entity, i, entry, side.getKey(), side.getValue());
            button.field_22764 = this.index == i;
            switch (side.getKey()) {
                case field_11036: {
                    layout.method_46452((class_8021)button, 0, 1);
                    break;
                }
                case field_11033: {
                    layout.method_46452((class_8021)button, 2, 1);
                    break;
                }
                case field_11043: {
                    layout.method_46452((class_8021)button, 1, 1);
                    break;
                }
                case field_11035: {
                    layout.method_46452((class_8021)button, 2, 0);
                    break;
                }
                case field_11034: {
                    layout.method_46452((class_8021)button, 1, 0);
                    break;
                }
                case field_11039: {
                    layout.method_46452((class_8021)button, 1, 2);
                }
            }
        }
        layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.addRenderableWidget(x$0);
        });
        return new SideConfigButtons(layout);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.menu.field_7761.stream().filter(slot -> slot instanceof InventorySlot).forEach(slot -> ((InventorySlot)((Object)slot)).setActive(!active));
    }

    public void toggle() {
        this.setActive(!this.method_37303());
    }

    public void setIndex(int index) {
        this.index = index;
        this.init();
    }

    public int getIndex() {
        return this.index;
    }

    public class_2561 getMessage() {
        return class_2561.method_43469((String)"side_config.ad_astra.title", (Object[])new Object[]{this.entity.getSideConfig().get(this.index).title()});
    }

    private record SideConfigButtons(class_7845 layout) {
        public void center(int x, int y, int width, int height) {
            this.layout.method_48222();
            this.layout.method_48229(x + (width - this.layout.method_25368()) / 2, y + (height - this.layout.method_25364()) / 2);
        }
    }
}

