/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.blocks.machines.EnergizerBlock;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.ModUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergizerBlockEntity
extends EnergyContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.PUSH_PULL, ConstantComponents.SIDE_CONFIG_ENERGY));

    public EnergizerBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, 1);
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return null;
    }

    public WrappedBlockEnergyContainer getEnergyStorage(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new SimpleEnergyContainer(MachineConfig.energizerEnergyCapacity, MachineConfig.OSTRUM.maxEnergyInOut, MachineConfig.OSTRUM.maxEnergyInOut){

            public void setEnergy(long energy) {
                super.setEnergy(energy);
                if (EnergizerBlockEntity.this.level().method_8510() % 10L != 0L) {
                    return;
                }
                EnergizerBlockEntity.this.onEnergyChange();
            }
        });
        return this.energyContainer;
    }

    @Override
    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        if (!this.canFunction()) {
            return;
        }
        this.distributeToChargeSlot(level, pos);
        if (time % 10L == 0L) {
            this.setLit(!this.method_5438(0).method_7960());
        }
    }

    @Override
    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pushEnergyNearby(this, pos, this.getEnergyStorage().maxExtract(), sideConfig.get(0), filter);
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(0), filter);
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return new int[]{0};
    }

    @Override
    public EnergyContainerMachineBlockEntity.ChargeSlotType getChargeSlotType() {
        return EnergyContainerMachineBlockEntity.ChargeSlotType.NONE;
    }

    public void onEnergyChange() {
        int charge = Math.round((float)this.getEnergyStorage().getStoredEnergy() / (float)this.getEnergyStorage().getMaxCapacity() * 5.0f);
        this.level().method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)EnergizerBlock.POWER, (Comparable)Integer.valueOf(charge)), 2);
    }

    public void distributeToChargeSlot(class_3218 level, class_2338 pos) {
        class_1799 stack = this.method_5438(0);
        if (stack.method_7960()) {
            return;
        }
        if (!EnergyContainer.holdsEnergy((class_1799)stack)) {
            return;
        }
        ItemStackHolder holder = new ItemStackHolder(stack);
        if (EnergyApi.moveEnergy((class_2586)this, null, (ItemStackHolder)holder, (long)this.getEnergyStorage().maxExtract(), (boolean)false) == 0L) {
            return;
        }
        this.method_5447(0, holder.getStack());
        ModUtils.sendParticles(level, class_2398.field_29644, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.8, (double)pos.method_10260() + 0.5, 2, 0.1, 0.1, 0.1, 0.1);
    }
}

