/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items;

import dev.architectury.injectables.annotations.PlatformOnly;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.DistributionMode;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyItem;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedItemEnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EtrionicCapacitorItem
extends class_1792
implements BotariumEnergyItem<WrappedItemEnergyContainer> {
    public static final String ACTIVE_TAG = "Active";
    public static final String MODE_TAG = "Mode";

    public EtrionicCapacitorItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static boolean active(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10545(ACTIVE_TAG)) {
            return tag.method_10577(ACTIVE_TAG);
        }
        return true;
    }

    public static boolean toggleActive(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        boolean active = EtrionicCapacitorItem.active(stack);
        tag.method_10556(ACTIVE_TAG, !active);
        return !active;
    }

    public static DistributionMode mode(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10545(MODE_TAG)) {
            return DistributionMode.values()[tag.method_10571(MODE_TAG)];
        }
        return DistributionMode.SEQUENTIAL;
    }

    public static DistributionMode toggleMode(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        DistributionMode mode = EtrionicCapacitorItem.mode(stack);
        DistributionMode toggled = mode == DistributionMode.SEQUENTIAL ? DistributionMode.ROUND_ROBIN : DistributionMode.SEQUENTIAL;
        tag.method_10567(MODE_TAG, (byte)toggled.ordinal());
        return toggled;
    }

    public WrappedItemEnergyContainer getEnergyStorage(class_1799 holder) {
        return new WrappedItemEnergyContainer(holder, (EnergyContainer)new SimpleEnergyContainer(250000L){

            public long maxInsert() {
                return 250L;
            }

            public long maxExtract() {
                return 500L;
            }
        });
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        WrappedItemEnergyContainer energy = this.getEnergyStorage(stack);
        tooltipComponents.add(TooltipUtils.getEnergyComponent(energy.getStoredEnergy(), energy.getMaxCapacity()));
        tooltipComponents.add(TooltipUtils.getActiveInactiveComponent(EtrionicCapacitorItem.active(stack)));
        tooltipComponents.add(TooltipUtils.getDistributionModeComponent(EtrionicCapacitorItem.mode(stack)));
        tooltipComponents.add(TooltipUtils.getMaxEnergyInComponent(energy.maxInsert()));
        tooltipComponents.add(TooltipUtils.getMaxEnergyOutComponent(energy.maxExtract()));
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.ETRIONIC_CAPACITOR_INFO);
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, @NotNull class_1657 player, @NotNull class_1268 usedHand) {
        if (level.method_8608()) {
            return class_1271.method_22430((Object)player.method_5998(usedHand));
        }
        class_1799 stack = player.method_5998(usedHand);
        if (player.method_5715()) {
            DistributionMode mode = EtrionicCapacitorItem.toggleMode(stack);
            player.method_7353(mode == DistributionMode.SEQUENTIAL ? ConstantComponents.CHANGE_MODE_SEQUENTIAL : ConstantComponents.CHANGE_MODE_ROUND_ROBIN, true);
        } else {
            boolean active = EtrionicCapacitorItem.toggleActive(stack);
            player.method_7353(active ? ConstantComponents.CAPACITOR_ENABLED : ConstantComponents.CAPACITOR_DISABLED, true);
        }
        return class_1271.method_22430((Object)stack);
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 level, @NotNull class_1297 entity, int slotId, boolean isSelected) {
        if (level.method_8608()) {
            return;
        }
        if (entity.field_6012 % 5 == 0) {
            return;
        }
        if (!EtrionicCapacitorItem.active(stack)) {
            return;
        }
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        class_1661 inventory = player.method_31548();
        WrappedItemEnergyContainer container = this.getEnergyStorage(stack);
        if (container.getStoredEnergy() == 0L) {
            return;
        }
        ItemStackHolder from = new ItemStackHolder(stack);
        switch (EtrionicCapacitorItem.mode(stack)) {
            case SEQUENTIAL: {
                this.distributeSequential(from, container.maxExtract() * 5L, inventory);
                break;
            }
            case ROUND_ROBIN: {
                this.distributeRoundRobin(from, container.maxExtract() * 5L, inventory);
            }
        }
        inventory.method_5447(slotId, from.getStack());
    }

    public void distributeSequential(ItemStackHolder from, long maxExtract, class_1661 inventory) {
        for (int i = inventory.method_5439() - 1; i >= 0; --i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || stack.method_31574((class_1792)this)) continue;
            ItemStackHolder to = new ItemStackHolder(stack);
            long moved = EnergyApi.moveEnergy((ItemStackHolder)from, (ItemStackHolder)to, (long)maxExtract, (boolean)false);
            inventory.method_5447(i, to.getStack());
            if (moved <= 0L) continue;
            return;
        }
    }

    public void distributeRoundRobin(ItemStackHolder from, long maxExtract, class_1661 inventory) {
        int i;
        int energyItems = 0;
        for (i = 0; i < inventory.method_5439(); ++i) {
            if (!EnergyContainer.holdsEnergy((class_1799)inventory.method_5438(i)) || inventory.method_5438(i).method_31574((class_1792)this)) continue;
            ++energyItems;
        }
        if (energyItems == 0) {
            return;
        }
        for (i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_31574((class_1792)this) || stack.method_7960() || stack.method_31574((class_1792)this)) continue;
            ItemStackHolder to = new ItemStackHolder(stack);
            EnergyApi.moveEnergy((ItemStackHolder)from, (ItemStackHolder)to, (long)(maxExtract / (long)energyItems), (boolean)false);
            inventory.method_5447(i, to.getStack());
        }
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        return this.getEnergyStorage(stack).getStoredEnergy() > 0L;
    }

    public int method_31569(@NotNull class_1799 stack) {
        WrappedItemEnergyContainer energyStorage = this.getEnergyStorage(stack);
        return (int)((double)energyStorage.getStoredEnergy() / (double)energyStorage.getMaxCapacity() * 13.0);
    }

    public int method_31571(@NotNull class_1799 stack) {
        return 6544578;
    }

    @PlatformOnly(value={"fabric"})
    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }
}

