/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils;

import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.DistributionMode;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class TooltipUtils {
    public static String getFormattedAmount(long number) {
        if (class_437.method_25442()) {
            return DecimalFormat.getNumberInstance().format(number);
        }
        NumberFormat compactFormat = NumberFormat.getCompactNumberInstance(Locale.ROOT, NumberFormat.Style.SHORT);
        compactFormat.setMaximumFractionDigits(2);
        return compactFormat.format(number);
    }

    public static class_2561 getEnergyComponent(long energy, long capacity) {
        return class_2561.method_43469((String)"tooltip.ad_astra.energy", (Object[])new Object[]{TooltipUtils.getFormattedAmount(energy), TooltipUtils.getFormattedAmount(capacity)}).method_27692(class_124.field_1065);
    }

    public static class_2561 getEnergyDifferenceComponent(long energy) {
        return class_2561.method_43469((String)"tooltip.ad_astra.energy_%s".formatted(energy < 0L ? "out" : "in"), (Object[])new Object[]{TooltipUtils.getFormattedAmount(Math.abs(energy))}).method_27692(class_124.field_1065);
    }

    public static class_2561 getMaxEnergyInComponent(long maxIn) {
        return class_2561.method_43469((String)"tooltip.ad_astra.max_energy_in", (Object[])new Object[]{TooltipUtils.getFormattedAmount(maxIn)}).method_27692(class_124.field_1060);
    }

    public static class_2561 getMaxEnergyOutComponent(long maxOut) {
        return class_2561.method_43469((String)"tooltip.ad_astra.max_energy_out", (Object[])new Object[]{TooltipUtils.getFormattedAmount(maxOut)}).method_27692(class_124.field_1060);
    }

    public static class_2561 getEnergyUsePerTickComponent(long usePerTick) {
        return class_2561.method_43469((String)"tooltip.ad_astra.energy_use_per_tick", (Object[])new Object[]{TooltipUtils.getFormattedAmount(Math.abs(usePerTick))}).method_27692(class_124.field_1075);
    }

    public static class_2561 getEnergyGenerationPerTickComponent(long generationPerTick) {
        return class_2561.method_43469((String)"tooltip.ad_astra.energy_generation_per_tick", (Object[])new Object[]{TooltipUtils.getFormattedAmount(Math.abs(generationPerTick))}).method_27692(class_124.field_1075);
    }

    public static class_2561 getActiveInactiveComponent(boolean active) {
        return active ? ConstantComponents.ACTIVE.method_27661().method_27692(class_124.field_1075) : ConstantComponents.INACTIVE.method_27661().method_27692(class_124.field_1075);
    }

    public static class_2561 getDistributionModeComponent(DistributionMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case DistributionMode.SEQUENTIAL -> ConstantComponents.SEQUENTIAL.method_27661().method_27692(class_124.field_1075);
            case DistributionMode.ROUND_ROBIN -> ConstantComponents.ROUND_ROBIN.method_27661().method_27692(class_124.field_1075);
        };
    }

    public static class_2561 getFluidComponent(FluidHolder fluid, long capacity, class_3611 fallback) {
        if (fluid.isEmpty()) {
            return class_2561.method_43469((String)"tooltip.ad_astra.fluid", (Object[])new Object[]{TooltipUtils.getFormattedAmount(0L), TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)capacity)), ClientFluidHooks.getDisplayName((FluidHolder)FluidHolder.ofMillibuckets((class_3611)fallback, (long)capacity))}).method_27692(class_124.field_1065);
        }
        return TooltipUtils.getFluidComponent(fluid, capacity);
    }

    public static class_2561 getFluidComponent(FluidHolder fluid, long capacity) {
        return class_2561.method_43469((String)"tooltip.ad_astra.fluid", (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)fluid.getFluidAmount())), TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)capacity)), ClientFluidHooks.getDisplayName((FluidHolder)fluid)}).method_27692(class_124.field_1065);
    }

    public static class_2561 getFluidDifferenceComponent(long fluid) {
        return class_2561.method_43469((String)"tooltip.ad_astra.fluid_%s".formatted(fluid < 0L ? "out" : "in"), (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)Math.abs(fluid)))}).method_27692(class_124.field_1065);
    }

    public static class_2561 getMaxFluidInComponent(long maxIn) {
        return class_2561.method_43469((String)"tooltip.ad_astra.max_fluid_in", (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)maxIn))}).method_27692(class_124.field_1060);
    }

    public static class_2561 getMaxFluidOutComponent(long maxOut) {
        return class_2561.method_43469((String)"tooltip.ad_astra.max_fluid_out", (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)maxOut))}).method_27692(class_124.field_1060);
    }

    public static class_2561 getFluidUsePerIterationComponent(long usePerTick) {
        return class_2561.method_43469((String)"tooltip.ad_astra.fluid_use_per_iteration", (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)Math.abs(usePerTick)))}).method_27692(class_124.field_1075);
    }

    public static class_2561 getFluidGenerationPerIterationComponent(long gainPerTick) {
        return class_2561.method_43469((String)"tooltip.ad_astra.fluid_generation_per_iteration", (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)Math.abs(gainPerTick)))}).method_27692(class_124.field_1075);
    }

    public static class_2561 getTicksPerIterationComponent(int time) {
        return class_2561.method_43469((String)"tooltip.ad_astra.ticks_per_iteration", (Object[])new Object[]{TooltipUtils.getFormattedAmount(time)}).method_27692(class_124.field_1075);
    }

    public static class_2561 getDirectionComponent(class_2350 direction) {
        return class_2561.method_43471((String)"direction.ad_astra.%s".formatted(direction.method_10151()));
    }

    public static class_2561 getRelativeDirectionComponent(class_2350 direction) {
        return class_2561.method_43471((String)"direction.ad_astra.relative.%s".formatted(direction.method_10151()));
    }

    public static void addDescriptionComponent(List<class_2561> tooltipComponents, class_2561 description) {
        if (!class_437.method_25442()) {
            tooltipComponents.add(ConstantComponents.SHIFT_DESCRIPTION);
            return;
        }
        for (class_5481 text : class_310.method_1551().field_1772.method_1728((class_5348)description, 200)) {
            StringBuilder builder = new StringBuilder();
            text.accept((i, style, codePoint) -> {
                builder.appendCodePoint(codePoint);
                return true;
            });
            tooltipComponents.add((class_2561)class_2561.method_43470((String)builder.toString()).method_27696(description.method_10866()));
        }
    }

    public static class_2561 getProgressComponent(int progress, int maxProgress) {
        return class_2561.method_43469((String)"tooltip.ad_astra.progress", (Object[])new Object[]{progress, maxProgress}).method_27692(class_124.field_1065);
    }

    public static class_2561 getEtaComponent(int progress, int maxProgress, boolean reverse) {
        int eta = (maxProgress - progress) / 20;
        if (reverse) {
            eta = progress / 20;
        }
        return class_2561.method_43469((String)"tooltip.ad_astra.eta", (Object[])new Object[]{eta}).method_27692(class_124.field_1065);
    }
}

