/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.proof;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.content.proof.LivingProofDurationAccessor;
import ad_astra_giselle_addon.common.content.proof.ProofFunction;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_2960;

public abstract class ProofAbstractUtils {
    private static final List<ProofAbstractUtils> _PROOFS = new ArrayList<ProofAbstractUtils>();
    public static final List<ProofAbstractUtils> PROOFS = Collections.unmodifiableList(_PROOFS);
    public static final String KEY_PROOF_DURATION = AdAstraGiselleAddon.rl("proof_duration").toString();
    public static final int GENERAL_PROOF_INTERVAL = 10;
    public static final int OXYGEN_PROOF_INTERVAL = 30;
    public static final long OXYGEN_PROOF_USING = FluidConstants.fromMillibuckets((long)1L);
    private final class_2960 id;
    private final String dataKey;
    private final List<ProofFunction> listeners;

    public static void reduceProofDuration(class_1309 living) {
        for (ProofAbstractUtils proof : PROOFS) {
            int currentDuration = proof.getProofDuration(living);
            if (currentDuration <= 0) continue;
            proof.setProofDuration(living, currentDuration - 1);
        }
    }

    protected ProofAbstractUtils(class_2960 id) {
        this.id = id;
        this.dataKey = id.toString();
        this.listeners = new ArrayList<ProofFunction>();
        _PROOFS.add(this);
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public int getProofDuration(class_1309 living) {
        return ((LivingProofDurationAccessor)living).ad_astra_giselle_addon$getProofDuration(this);
    }

    public void setProofDuration(class_1309 living, int proofDuration) {
        ((LivingProofDurationAccessor)living).ad_astra_giselle_addon$setProofDuration(this, proofDuration);
    }

    public boolean tryProvideProof(class_1309 living) {
        if (this.getProofDuration(living) > 0) {
            return true;
        }
        int proofDuration = this.post(living);
        if (proofDuration > 0) {
            this.setProofDuration(living, proofDuration);
            return true;
        }
        return false;
    }

    public void register(ProofFunction event) {
        this.listeners.add(event);
    }

    public boolean unregister(ProofFunction event) {
        return this.listeners.remove(event);
    }

    public int post(class_1309 living) {
        for (ProofFunction event : this.listeners) {
            int proofFunction = event.provide(living);
            if (proofFunction <= 0) continue;
            return proofFunction;
        }
        return 0;
    }
}

