/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.inventory;

import compasses.expandedstorage.impl.inventory.handler.InventorySlotFunction;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public final class VariableInventory
implements class_1263 {
    private final class_1263[] parts;
    private final int size;
    private final int maxStackCount;

    private VariableInventory(class_1263 ... parts) {
        for (int i = 0; i < parts.length; ++i) {
            Objects.requireNonNull(parts[i], "part at index" + i + " must not be null");
        }
        this.parts = parts;
        this.size = Arrays.stream(parts).mapToInt(class_1263::method_5439).sum();
        this.maxStackCount = parts[0].method_5444();
        for (class_1263 part : parts) {
            assert (part.method_5444() == this.maxStackCount) : "all parts must have equal max stack counts.";
        }
    }

    public static class_1263 of(class_1263 ... parts) {
        assert (parts.length > 0) : "parts must contain at least 1 inventory";
        if (parts.length == 1) {
            return parts[0];
        }
        return new VariableInventory(parts);
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        for (class_1263 part : this.parts) {
            if (part.method_5442()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        this.validateSlotIndex(slot);
        return this.applyFunctionToSlot(slot, class_1263::method_5438);
    }

    private void validateSlotIndex(int slot) {
        assert (slot >= 0 && slot < this.method_5439()) : "slot index out of range";
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        this.validateSlotIndex(slot);
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.method_5434(rSlot, amount));
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        this.validateSlotIndex(slot);
        return this.applyFunctionToSlot(slot, class_1263::method_5441);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.validateSlotIndex(slot);
        this.consumeSlot(slot, (part, rSlot) -> part.method_5447(rSlot, stack));
    }

    public int method_5444() {
        return this.maxStackCount;
    }

    public void method_5431() {
        for (class_1263 part : this.parts) {
            part.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        for (class_1263 part : this.parts) {
            if (part.method_5443(player)) continue;
            return false;
        }
        return true;
    }

    public void method_5435(class_1657 player) {
        for (class_1263 part : this.parts) {
            part.method_5435(player);
        }
    }

    public void method_5432(class_1657 player) {
        for (class_1263 part : this.parts) {
            part.method_5432(player);
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        this.validateSlotIndex(slot);
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.method_5437(rSlot, stack));
    }

    public int method_18861(class_1792 item) {
        int count = 0;
        for (class_1263 part : this.parts) {
            count += part.method_18861(item);
        }
        return count;
    }

    public boolean method_18862(Set<class_1792> set) {
        for (class_1263 part : this.parts) {
            if (!part.method_18862(set)) continue;
            return true;
        }
        return false;
    }

    public void method_5448() {
        for (class_1263 part : this.parts) {
            part.method_5448();
        }
    }

    private void consumeSlot(int slot, ObjIntConsumer<class_1263> consumer) {
        for (class_1263 part : this.parts) {
            int inventorySize = part.method_5439();
            if (slot >= inventorySize) {
                slot -= inventorySize;
                continue;
            }
            consumer.accept(part, slot);
            return;
        }
        throw new IllegalStateException("consumeSlot called without validating slot bounds.");
    }

    private <T> T applyFunctionToSlot(int slot, InventorySlotFunction<class_1263, T> function) {
        for (class_1263 part : this.parts) {
            int inventorySize = part.method_5439();
            if (slot >= inventorySize) {
                slot -= inventorySize;
                continue;
            }
            return function.apply(part, slot);
        }
        throw new IllegalStateException("applyFunctionToSlot called without validating slot bounds.");
    }

    public boolean containsPart(class_1263 part) {
        for (class_1263 inventory : this.parts) {
            if (inventory != part) continue;
            return true;
        }
        return false;
    }
}

