/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.api.ExpandedStorageAccessors;
import compasses.expandedstorage.impl.block.AbstractChestBlock;
import compasses.expandedstorage.impl.block.entity.extendable.OpenableBlockEntity;
import compasses.expandedstorage.impl.item.StorageConversionKit;
import compasses.expandedstorage.impl.item.ToolUsageResult;
import compasses.expandedstorage.impl.recipe.ConversionRecipe;
import compasses.expandedstorage.impl.recipe.conditions.RecipeCondition;
import compasses.expandedstorage.impl.recipe.misc.PartialBlockState;
import compasses.expandedstorage.impl.recipe.misc.RecipeTool;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;

public class BlockConversionRecipe<O extends class_2248>
extends ConversionRecipe<class_2680> {
    private final PartialBlockState<O> output;

    public BlockConversionRecipe(RecipeTool recipeTool, PartialBlockState<O> output, RecipeCondition input) {
        super(recipeTool, input);
        this.output = output;
    }

    public final ToolUsageResult process(class_1937 level, class_1657 player, class_1799 tool, class_2680 clickedState, class_2338 clickedPos) {
        ArrayList<class_2338> convertPositions = new ArrayList<class_2338>();
        convertPositions.add(clickedPos);
        if (clickedState.method_28498((class_2769)class_2741.field_12506)) {
            class_2745 type = (class_2745)clickedState.method_11654((class_2769)class_2741.field_12506);
            if (type != class_2745.field_12569) {
                convertPositions.add(clickedPos.method_10093(class_2281.method_9758((class_2680)clickedState)));
            }
        } else if (clickedState.method_28498(AbstractChestBlock.CURSED_CHEST_TYPE) && clickedState.method_28498((class_2769)class_2741.field_12481)) {
            ExpandedStorageAccessors.getAttachedChestDirection(clickedState).ifPresent(direction -> convertPositions.add(clickedPos.method_10093(direction)));
        }
        if (tool.method_7947() < convertPositions.size() && !player.method_7337()) {
            return StorageConversionKit.NOT_ENOUGH_UPGRADES;
        }
        HashMap<class_2338, InputState> originalStates = new HashMap<class_2338, InputState>();
        for (class_2338 position : convertPositions) {
            class_2586 entity = level.method_8321(position);
            if (!(entity instanceof OpenableBlockEntity) && !(entity instanceof class_2621)) {
                return ToolUsageResult.fail();
            }
            originalStates.put(position, new InputState(level.method_8320(position), entity));
        }
        int toolsUsed = 0;
        for (class_2338 position : convertPositions) {
            class_2371 originalItems;
            OpenableBlockEntity entity;
            InputState input = (InputState)originalStates.get(position);
            class_2680 originalState = input.state();
            class_2680 newState = this.output.getBlock().method_34725(originalState);
            if (originalState.method_28498((class_2769)class_2741.field_12506) && newState.method_28498(AbstractChestBlock.CURSED_CHEST_TYPE)) {
                newState = (class_2680)newState.method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)EsChestType.from((class_2745)originalState.method_11654((class_2769)class_2741.field_12506))));
            }
            if ((newState = this.output.transform(newState)) == originalState) continue;
            class_2561 customName = null;
            class_2487 tagForLock = input.entity().method_38244();
            class_2586 class_25862 = input.entity();
            if (class_25862 instanceof OpenableBlockEntity) {
                entity = (OpenableBlockEntity)class_25862;
                originalItems = entity.getItems();
                if (entity.method_16914()) {
                    customName = entity.method_5477();
                }
            } else {
                class_25862 = input.entity();
                if (class_25862 instanceof class_2621) {
                    class_2621 entity2 = (class_2621)class_25862;
                    originalItems = entity2.method_11282();
                    customName = entity2.method_5797();
                } else {
                    throw new IllegalStateException();
                }
            }
            level.method_8544(position);
            if (level.method_8501(position, newState)) {
                class_25862 = level.method_8321(position);
                if (class_25862 instanceof OpenableBlockEntity) {
                    int i;
                    entity = (OpenableBlockEntity)class_25862;
                    class_2371<class_1799> newInventory = entity.getItems();
                    int commonSize = Math.min(originalItems.size(), newInventory.size());
                    for (i = 0; i < commonSize; ++i) {
                        newInventory.set(i, (class_1799)originalItems.get(i));
                    }
                    if (newInventory.size() < originalItems.size()) {
                        for (i = newInventory.size(); i < originalItems.size(); ++i) {
                            class_1264.method_5449((class_1937)level, (double)position.method_10263(), (double)position.method_10264(), (double)position.method_10260(), (class_1799)((class_1799)originalItems.get(i)));
                        }
                    }
                    entity.setCustomName(customName);
                    entity.getLockable().readLock(tagForLock);
                }
                ++toolsUsed;
                continue;
            }
            level.method_8438(input.entity());
        }
        if (this.recipeTool instanceof RecipeTool.UpgradeTool) {
            tool.method_7939(tool.method_7947() - toolsUsed);
        }
        return toolsUsed > 0 ? ToolUsageResult.slowSuccess() : ToolUsageResult.fail();
    }

    public void writeToBuffer(class_2540 buffer) {
        this.recipeTool.writeToBuffer(buffer);
        this.output.writeToBuffer(buffer);
        buffer.method_10812(this.input.getNetworkId());
        this.input.writeToBuffer(buffer);
    }

    public static BlockConversionRecipe<?> readFromBuffer(class_2540 buffer) {
        RecipeTool recipeTool = RecipeTool.fromNetworkBuffer(buffer);
        PartialBlockState<?> output = PartialBlockState.readFromBuffer(buffer);
        RecipeCondition inputs = RecipeCondition.readFromNetworkBuffer(buffer);
        return new BlockConversionRecipe(recipeTool, output, inputs);
    }

    @Override
    public JsonElement toJson() {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "expandedstorage:block_conversion");
        recipe.add("tool", (JsonElement)this.recipeTool.toJson());
        recipe.add("result", (JsonElement)this.output.toJson());
        recipe.add("inputs", this.input.toJson(null));
        return recipe;
    }

    private record InputState(class_2680 state, class_2586 entity) {
    }
}

