/*
 * Decompiled with CFR 0.152.
 */
package forge.net.creep3rcrafter.mysticpotions.register;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import forge.net.creep3rcrafter.mysticpotions.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ModEffects {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((String)"mysticpotions", (ResourceKey)Registries.f_256929_);
    public static final RegistrySupplier<MobEffect> UNDYING = EFFECTS.register("undying", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 16766527){

        public void m_6742_(LivingEntity livingEntity, int amplifier) {
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> AIR_SWIM = EFFECTS.register("air_swim", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 24991){

        public void m_6742_(@NotNull LivingEntity livingEntity, int amplifier) {
            super.m_6742_(livingEntity, amplifier);
            if (!(!livingEntity.m_20142_() || livingEntity.m_20159_() || livingEntity.m_21023_(MobEffects.f_19593_) || livingEntity.m_204029_(FluidTags.f_13131_) || livingEntity.m_204031_(FluidTags.f_13131_, 0.014))) {
                livingEntity.m_183634_();
                livingEntity.f_19800_ = true;
                livingEntity.f_19798_ = true;
                livingEntity.m_20282_(true);
                Vec3 vec32 = livingEntity.m_20184_();
                float f = 1.08f;
                if (livingEntity.f_19862_ && livingEntity.m_6147_()) {
                    vec32 = new Vec3(vec32.f_82479_, 0.25, vec32.f_82481_);
                }
                livingEntity.m_20256_(vec32.m_82542_((double)f, (double)f + 0.05, (double)f));
                livingEntity.m_146850_(GameEvent.f_157786_);
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> WARMING = EFFECTS.register("warming", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 16757504){

        public void m_6742_(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.m_9236_().m_5776_()) {
                ServerLevel serverLevel = (ServerLevel)livingEntity.m_9236_();
                livingEntity.m_146917_(0);
                if (livingEntity instanceof SnowGolem && serverLevel.m_7654_().m_129921_() % 20 == 0) {
                    livingEntity.m_6469_(livingEntity.m_269291_().m_269425_(), (float)(amplifier + 1));
                }
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> HOMING = EFFECTS.register("homing", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 16736892){

        /*
         * Enabled aggressive block sorting
         */
        public void m_6742_(LivingEntity livingEntity, int amplifier) {
            if (livingEntity.m_9236_().m_5776_()) return;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                if (!livingEntity.m_5833_()) {
                    if (serverPlayer.m_8961_() != null && serverPlayer.m_9236_().m_8055_(serverPlayer.m_8961_()).m_60734_() instanceof BedBlock) {
                        Vec3 pos = Vec3.m_82539_((Vec3i)serverPlayer.m_8961_());
                        serverPlayer.f_8906_.m_9774_(pos.f_82479_, pos.f_82480_, pos.f_82481_, Mth.m_14177_((float)serverPlayer.m_146908_()), Mth.m_14177_((float)serverPlayer.m_146909_()));
                        return;
                    }
                    Vec3 pos = Vec3.m_82539_((Vec3i)serverPlayer.m_9236_().m_220360_());
                    serverPlayer.f_8906_.m_9774_(pos.f_82479_, pos.f_82480_, pos.f_82481_, Mth.m_14177_((float)serverPlayer.m_146908_()), Mth.m_14177_((float)serverPlayer.m_146909_()));
                    return;
                }
            }
            Vec3 pos = Vec3.m_82539_((Vec3i)livingEntity.m_9236_().m_220360_());
            livingEntity.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration == 1;
        }

        public boolean m_8093_() {
            return true;
        }
    });
    public static final RegistrySupplier<MobEffect> RECOVERY = EFFECTS.register("recovery", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 9044042){

        public void m_6742_(LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.m_9236_().m_5776_() && livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                if (!livingEntity.m_5833_() && serverPlayer.m_219759_().isPresent() && serverPlayer.m_9236_().m_46472_() == ((GlobalPos)serverPlayer.m_219759_().get()).m_122640_()) {
                    Vec3 pos = Vec3.m_82539_((Vec3i)((GlobalPos)serverPlayer.m_219759_().get()).m_122646_());
                    serverPlayer.f_8906_.m_9774_(pos.f_82479_, pos.f_82480_, pos.f_82481_, Mth.m_14177_((float)serverPlayer.m_146908_()), Mth.m_14177_((float)serverPlayer.m_146909_()));
                }
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration == 1;
        }

        public boolean m_8093_() {
            return true;
        }
    });
    public static final RegistrySupplier<MobEffect> TELEPORTATION = EFFECTS.register("teleportation", () -> new MobEffect(MobEffectCategory.NEUTRAL, 13041919){

        public void m_6742_(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_9236_().m_7654_() != null && livingEntity.m_9236_().m_7654_().m_129921_() % (20 + livingEntity.m_217043_().m_216339_(-10, 40)) == 0) {
                ServerLevel level = livingEntity.m_9236_().m_7654_().m_129880_(livingEntity.m_9236_().m_46472_());
                assert (level != null);
                if (!level.f_46443_) {
                    double d = livingEntity.m_20185_();
                    double e = livingEntity.m_20186_();
                    double f = livingEntity.m_20189_();
                    for (int i = 0; i < 32; ++i) {
                        double g = livingEntity.m_20185_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 32.0;
                        double h = Mth.m_14008_((double)(livingEntity.m_20186_() + (double)(livingEntity.m_217043_().m_188503_(32) - 16)), (double)level.m_141937_(), (double)(level.m_141937_() + level.m_143344_() - 1));
                        double j = livingEntity.m_20189_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 32.0;
                        if (livingEntity.m_20159_()) {
                            livingEntity.m_8127_();
                        }
                        Vec3 vec3 = livingEntity.m_20182_();
                        if (!livingEntity.m_20984_(g, h, j, true)) continue;
                        level.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)livingEntity));
                        SoundEvent soundEvent = livingEntity instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
                        level.m_6263_((Player)null, d, e, f, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
                        livingEntity.m_5496_(soundEvent, 1.0f, 1.0f);
                        break;
                    }
                }
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> SPLIPPERY = EFFECTS.register("slippery", () -> new MobEffect(MobEffectCategory.NEUTRAL, 0x17FFFF){

        public void m_6742_(@NotNull LivingEntity livingEntity, int amplifier) {
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration > 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> THUNDEROUS = EFFECTS.register("thunderous", () -> new MobEffect(MobEffectCategory.HARMFUL, 0xE0FFFF){

        public void m_6742_(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.m_9236_().m_5776_()) {
                ServerLevel serverLevel = (ServerLevel)livingEntity.m_9236_();
                Utils.lightning(livingEntity, serverLevel, amplifier);
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration == 1;
        }

        public boolean m_8093_() {
            return true;
        }
    });
    public static final RegistrySupplier<MobEffect> EXPLOSIVE = EFFECTS.register("explosive", () -> new MobEffect(MobEffectCategory.HARMFUL, 4522008){

        public void m_6742_(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.m_9236_().m_5776_()) {
                ServerLevel serverLevel = (ServerLevel)livingEntity.m_9236_();
                if (!livingEntity.m_5833_()) {
                    if (livingEntity.m_9236_().m_46472_() == Level.f_46429_) {
                        Utils.explode(serverLevel, livingEntity.m_20183_(), (float)amplifier, true);
                    } else if (amplifier > 4) {
                        Utils.explode(serverLevel, livingEntity.m_20183_(), (float)amplifier, true);
                    } else {
                        Utils.explode(serverLevel, livingEntity.m_20183_(), (float)amplifier);
                    }
                }
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration == 1;
        }

        public boolean m_8093_() {
            return true;
        }
    });
    public static final RegistrySupplier<MobEffect> BURNING = EFFECTS.register("burning", () -> new MobEffect(MobEffectCategory.HARMFUL, 16740608){

        public void m_6742_(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.m_20071_()) {
                livingEntity.m_20254_(1);
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> FREEZING = EFFECTS.register("freezing", () -> new MobEffect(MobEffectCategory.HARMFUL, 0x17FFFF){

        public void m_6742_(LivingEntity livingEntity, int amplifier) {
            if (livingEntity.m_142079_()) {
                livingEntity.m_146924_(true);
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> CORROSIVE = EFFECTS.register("corrosive", () -> new MobEffect(MobEffectCategory.HARMFUL, 10157824){

        public void m_6742_(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.m_9236_().m_5776_()) {
                ServerLevel serverLevel = (ServerLevel)livingEntity.m_9236_();
                Random random = new Random();
                if (!livingEntity.m_5833_() && serverLevel.m_7654_().m_129921_() % 10 == 0) {
                    MinecraftServer server = serverLevel.m_7654_();
                    if (livingEntity instanceof ServerPlayer) {
                        ArrayList<Item> items = new ArrayList<Item>();
                        items.add(Items.f_42749_);
                        items.add(Items.f_41834_);
                        items.add(Items.f_42416_);
                        items.add(Items.f_151052_);
                        items.add(Items.f_42419_);
                        items.add(Items.f_42418_);
                        List<Item> results = Utils.recipesContainsItems(server, RecipeType.f_44107_, items);
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.f_44108_, items));
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.f_44113_, items));
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.f_44109_, items));
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.f_44110_, items));
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.f_44112_, items));
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.f_44111_, items));
                        ArrayList<Item> resultsWithoutDuplicates = new ArrayList<Item>(new HashSet<Item>(results));
                        Inventory inventory = ((ServerPlayer)livingEntity).m_150109_();
                        for (int i = 0; i < inventory.m_6643_(); ++i) {
                            Item item = inventory.m_8020_(i).m_41720_();
                            ItemStack itemStack = inventory.m_8020_(i);
                            if (itemStack.m_41763_()) {
                                Utils.damageItem(livingEntity, itemStack, 1 + amplifier);
                                continue;
                            }
                            if (itemStack.m_41763_() || !resultsWithoutDuplicates.contains(item) || random.nextInt(100) < 90 || random.nextInt(3) > amplifier) continue;
                            itemStack.m_41774_(1);
                        }
                    } else if (livingEntity instanceof IronGolem) {
                        livingEntity.m_6469_(livingEntity.m_269291_().m_269425_(), 1.0f + (float)amplifier);
                    } else {
                        if (livingEntity.m_21033_(EquipmentSlot.MAINHAND)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.MAINHAND, 1 + amplifier);
                        }
                        if (livingEntity.m_21033_(EquipmentSlot.OFFHAND)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.OFFHAND, 1 + amplifier);
                        }
                        if (livingEntity.m_21033_(EquipmentSlot.HEAD)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.HEAD, 1 + amplifier);
                        }
                        if (livingEntity.m_21033_(EquipmentSlot.CHEST)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.CHEST, 1 + amplifier);
                        }
                        if (livingEntity.m_21033_(EquipmentSlot.LEGS)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.LEGS, 1 + amplifier);
                        }
                        if (livingEntity.m_21033_(EquipmentSlot.FEET)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.FEET, 1 + amplifier);
                        }
                    }
                }
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> GRAVITATION = EFFECTS.register("gravitation", () -> new MobEffect(MobEffectCategory.HARMFUL, 11350783){

        public void m_6742_(@NotNull LivingEntity livingEntity, int amplifier) {
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> FATAL_POISON = EFFECTS.register("fatal_poison", () -> new MobEffect(MobEffectCategory.HARMFUL, 0xFF00FF){

        public void m_6742_(@NotNull LivingEntity livingEntity, int amplifier) {
            livingEntity.m_6469_(livingEntity.m_269291_().m_269425_(), 1.0f);
        }

        public boolean m_19443_(int duration, int amplifier) {
            int k = 25 >> amplifier;
            if (k > 0) {
                return duration % k == 0;
            }
            return true;
        }
    });
    public static final RegistrySupplier<MobEffect> PROTECTION = EFFECTS.register("protection", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 8751501){

        public void m_6742_(LivingEntity livingEntity, int amplifier) {
            if (livingEntity.m_21204_().m_22171_(Attributes.f_22284_)) {
                this.m_19472_(Attributes.f_22284_, "9aa8ab7f-3f42-4c2d-acc9-30a56847c3fc", 1.0, AttributeModifier.Operation.ADDITION);
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> SILENCE = EFFECTS.register("silence", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 92){

        public void m_6742_(LivingEntity livingEntity, int amplifier) {
            livingEntity.m_20225_(true);
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> NULLIFIER = EFFECTS.register("nullifier", () -> new MobEffect(MobEffectCategory.NEUTRAL, 13691391){

        public void m_6742_(LivingEntity livingEntity, int amplifier) {
            for (MobEffectInstance effectInstance : livingEntity.m_21220_()) {
                if (effectInstance.m_19544_() == NULLIFIER.get()) continue;
                livingEntity.m_21195_(effectInstance.m_19544_());
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> INFECTION = EFFECTS.register("infection", () -> new MobEffect(MobEffectCategory.HARMFUL, 14848){

        public void m_6742_(LivingEntity livingEntity, int amplifier) {
            if (livingEntity.m_21023_((MobEffect)this)) {
                int duration = livingEntity.m_21124_((MobEffect)this).m_19557_();
                if (duration == 600) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 40));
                }
                if (duration == 300) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 300));
                }
                if (duration == 200) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200));
                }
                if (duration == 1) {
                    if (livingEntity instanceof Player && !((Player)livingEntity).m_7500_()) {
                        livingEntity.m_6469_(livingEntity.m_269291_().m_269425_(), 20.0f);
                        if (livingEntity.m_21224_()) {
                            Zombie zombie = new Zombie(EntityType.f_20501_, livingEntity.m_9236_());
                            zombie.m_20359_((Entity)livingEntity);
                            zombie.m_6593_(livingEntity.m_7770_());
                            zombie.m_21553_(true);
                            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                                ItemStack itemStack = livingEntity.m_6844_(equipmentSlot);
                                if (itemStack.m_41619_()) continue;
                                zombie.m_8061_(equipmentSlot, itemStack.m_41777_());
                                zombie.m_21409_(equipmentSlot, zombie.m_21519_(equipmentSlot));
                                itemStack.m_41764_(0);
                            }
                            livingEntity.m_9236_().m_7967_((Entity)zombie);
                            if (livingEntity.m_20159_()) {
                                Entity entity = livingEntity.m_20202_();
                                livingEntity.m_8127_();
                                zombie.m_7998_(entity, true);
                            }
                            zombie.m_7292_(new MobEffectInstance((MobEffect)this, 1200));
                            livingEntity.m_146870_();
                        }
                    } else if (livingEntity instanceof Villager) {
                        Mob mob = ((Mob)livingEntity).m_21406_(EntityType.f_20530_, true);
                        mob.m_7292_(new MobEffectInstance((MobEffect)this, 1200));
                    } else if (livingEntity instanceof Piglin) {
                        Mob mob = ((Mob)livingEntity).m_21406_(EntityType.f_20531_, true);
                        mob.m_7292_(new MobEffectInstance((MobEffect)this, 1200));
                    } else if (livingEntity instanceof Hoglin) {
                        Mob mob = ((Mob)livingEntity).m_21406_(EntityType.f_20500_, true);
                        mob.m_7292_(new MobEffectInstance((MobEffect)this, 1200));
                    } else if (livingEntity instanceof Horse) {
                        Mob mob = ((Mob)livingEntity).m_21406_(EntityType.f_20502_, true);
                        mob.m_7292_(new MobEffectInstance((MobEffect)this, 1200));
                    } else if (!(livingEntity instanceof Zombie || livingEntity instanceof ZombieHorse || livingEntity instanceof Zoglin)) {
                        livingEntity.m_6469_(livingEntity.m_269291_().m_269425_(), 5.0f);
                    }
                }
            }
        }

        public boolean m_19443_(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean m_8093_() {
            return false;
        }
    });
}

